/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Doubles;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.Correspondence;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class PrimitiveDoubleArraySubject
extends AbstractArraySubject<PrimitiveDoubleArraySubject, double[]> {
    PrimitiveDoubleArraySubject(FailureStrategy failureStrategy, @Nullable double[] o) {
        super(failureStrategy, o);
    }

    @Override
    protected String underlyingType() {
        return "double";
    }

    @Override
    protected List<Double> listRepresentation() {
        return Doubles.asList((double[])((double[])this.getSubject()));
    }

    @Override
    @Deprecated
    public void isEqualTo(Object expected) {
        throw new UnsupportedOperationException("Comparing raw equality of doubles is unsafe, use isEqualTo(double[] array, double tolerance) instead.");
    }

    @Deprecated
    public void isEqualTo(Object expected, double tolerance) {
        double[] actual = (double[])this.getSubject();
        if (actual == expected) {
            return;
        }
        try {
            double[] expectedArray = (double[])expected;
            if (expectedArray.length != actual.length) {
                this.failWithRawMessage("Arrays are of different lengths. expected: %s, actual %s", Doubles.asList((double[])expectedArray), Doubles.asList((double[])actual));
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expectedArray.length; ++i) {
                if (MathUtil.equalWithinTolerance(actual[i], expectedArray[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (!unequalIndices.isEmpty()) {
                this.fail("is equal to", (Object)Doubles.asList((double[])expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    @Deprecated
    public void isNotEqualTo(Object expected) {
        throw new UnsupportedOperationException("Comparing raw equality of doubles is unsafe, use isNotEqualTo(double[] array, double tolerance) instead.");
    }

    @Deprecated
    public void isNotEqualTo(Object expectedArray, double tolerance) {
        double[] actual = (double[])this.getSubject();
        try {
            double[] expected = (double[])expectedArray;
            if (actual == expected) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Doubles.asList((double[])expected));
            }
            if (expected.length != actual.length) {
                return;
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expected.length; ++i) {
                if (MathUtil.equalWithinTolerance(actual[i], expected[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (unequalIndices.isEmpty()) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Doubles.asList((double[])expected));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public TolerantPrimitiveDoubleArrayComparison hasValuesWithin(final double tolerance) {
        return new TolerantPrimitiveDoubleArrayComparison(){

            @Override
            public void ofElementsIn(Iterable<? extends Number> expected) {
                DoubleSubject.checkTolerance(tolerance);
                double[] actual = (double[])Preconditions.checkNotNull(PrimitiveDoubleArraySubject.this.getSubject());
                ArrayList<Integer> mismatches = new ArrayList<Integer>();
                int expectedCount = 0;
                for (Number number : expected) {
                    if (expectedCount < actual.length && !MathUtil.equalWithinTolerance(actual[expectedCount], number.doubleValue(), tolerance)) {
                        mismatches.add(expectedCount);
                    }
                    ++expectedCount;
                }
                if (actual.length != expectedCount) {
                    PrimitiveDoubleArraySubject.this.failWithRawMessage("Not true that %s has values within %s of <%s>. Expected length <%s> but got <%s>", PrimitiveDoubleArraySubject.this.getDisplaySubject(), tolerance, Iterables.toString(expected), expectedCount, actual.length);
                }
                if (!mismatches.isEmpty()) {
                    PrimitiveDoubleArraySubject.this.failWithBadResults("has values within " + tolerance + " of", Iterables.toString(expected), "differs at indexes", mismatches);
                }
            }
        };
    }

    @Deprecated
    public TolerantPrimitiveDoubleArrayComparison hasValuesNotWithin(final double tolerance) {
        return new TolerantPrimitiveDoubleArrayComparison(){

            @Override
            public void ofElementsIn(Iterable<? extends Number> expected) {
                DoubleSubject.checkTolerance(tolerance);
                double[] actual = (double[])Preconditions.checkNotNull(PrimitiveDoubleArraySubject.this.getSubject());
                int expectedCount = 0;
                for (Number number : expected) {
                    if (expectedCount < actual.length && MathUtil.notEqualWithinTolerance(actual[expectedCount], number.doubleValue(), tolerance)) {
                        return;
                    }
                    ++expectedCount;
                }
                if (actual.length == expectedCount) {
                    PrimitiveDoubleArraySubject.this.fail("has values not within " + tolerance + " of", (Object)Iterables.toString(expected));
                }
            }
        };
    }

    public IterableSubject.UsingCorrespondence<Number, Number> withTolerance(double tolerance) {
        return new IterableSubject(this.failureStrategy, (Iterable<?>)this.listRepresentation()).comparingElementsUsing(Correspondence.tolerance(tolerance));
    }

    public static abstract class TolerantPrimitiveDoubleArrayComparison {
        private TolerantPrimitiveDoubleArrayComparison() {
        }

        public void of(double ... expected) {
            this.ofElementsIn(Doubles.asList((double[])expected));
        }

        public abstract void ofElementsIn(Iterable<? extends Number> var1);

        @Deprecated
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("If you meant to compare double arrays, use .of() or .ofElementsIn() instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

