/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.primitives.Chars;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class PrimitiveCharArraySubject
extends AbstractArraySubject<PrimitiveCharArraySubject, char[]> {
    PrimitiveCharArraySubject(FailureStrategy failureStrategy, @Nullable char[] o) {
        super(failureStrategy, o);
    }

    @Override
    protected String underlyingType() {
        return "char";
    }

    @Override
    protected List<Character> listRepresentation() {
        return Chars.asList((char[])((char[])this.getSubject()));
    }

    @Override
    public void isEqualTo(Object expected) {
        char[] actual = (char[])this.getSubject();
        if (actual == expected) {
            return;
        }
        try {
            char[] expectedArray = (char[])expected;
            if (!Arrays.equals(actual, expectedArray)) {
                this.fail("is equal to", (Object)Chars.asList((char[])expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    public void isNotEqualTo(Object expected) {
        char[] actual = (char[])this.getSubject();
        try {
            char[] expectedArray = (char[])expected;
            if (actual == expected || Arrays.equals(actual, expectedArray)) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Chars.asList((char[])expectedArray));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public IterableSubject asList() {
        return new IterableSubject(this.failureStrategy, (Iterable<?>)this.listRepresentation());
    }
}

