/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.primitives.Booleans;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class PrimitiveBooleanArraySubject
extends AbstractArraySubject<PrimitiveBooleanArraySubject, boolean[]> {
    PrimitiveBooleanArraySubject(FailureStrategy failureStrategy, @Nullable boolean[] o) {
        super(failureStrategy, o);
    }

    @Override
    protected String underlyingType() {
        return "boolean";
    }

    @Override
    protected List<Boolean> listRepresentation() {
        return Booleans.asList((boolean[])((boolean[])this.getSubject()));
    }

    @Override
    public void isEqualTo(Object expected) {
        boolean[] actual = (boolean[])this.getSubject();
        if (actual == expected) {
            return;
        }
        try {
            boolean[] expectedArray = (boolean[])expected;
            if (!Arrays.equals(actual, expectedArray)) {
                this.fail("is equal to", (Object)Booleans.asList((boolean[])expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    public void isNotEqualTo(Object expected) {
        boolean[] actual = (boolean[])this.getSubject();
        try {
            boolean[] expectedArray = (boolean[])expected;
            if (actual == expected || Arrays.equals(actual, expectedArray)) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Booleans.asList((boolean[])expectedArray));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public IterableSubject asList() {
        return new IterableSubject(this.failureStrategy, (Iterable<?>)this.listRepresentation());
    }
}

