/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import javax.annotation.Nullable;

public final class MultisetSubject
extends IterableSubject {
    MultisetSubject(FailureStrategy failureStrategy, @Nullable Multiset<?> multiset) {
        super(failureStrategy, (Iterable<?>)multiset);
    }

    @Override
    public MultisetSubject named(String name) {
        super.named(name);
        return this;
    }

    public final void hasCount(@Nullable Object element, int expectedCount) {
        Preconditions.checkArgument((expectedCount >= 0 ? 1 : 0) != 0, (String)"expectedCount(%s) must be >= 0", (Object[])new Object[]{expectedCount});
        int actualCount = ((Multiset)this.getSubject()).count(element);
        if (actualCount != expectedCount) {
            this.failWithBadResults("has a count for <" + element + "> of", expectedCount, "is", actualCount);
        }
    }
}

