/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nullable;

public final class MapSubject
extends Subject<MapSubject, Map<?, ?>> {
    MapSubject(FailureStrategy failureStrategy, @Nullable Map<?, ?> map) {
        super(failureStrategy, map);
    }

    @Override
    public void isEqualTo(@Nullable Object other) {
        if (!Objects.equal(this.getSubject(), (Object)other)) {
            if (other instanceof Map) {
                MapDifference diff = Maps.difference((Map)((Map)other), (Map)((Map)this.getSubject()));
                String errorMsg = "The subject";
                if (!diff.entriesOnlyOnLeft().isEmpty()) {
                    errorMsg = errorMsg + " is missing the following entries: " + diff.entriesOnlyOnLeft();
                    if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                        errorMsg = errorMsg + " and";
                    }
                }
                if (!diff.entriesOnlyOnRight().isEmpty()) {
                    errorMsg = errorMsg + " has the following extra entries: " + diff.entriesOnlyOnRight();
                    if (!diff.entriesDiffering().isEmpty()) {
                        errorMsg = errorMsg + " and";
                    }
                }
                if (!diff.entriesDiffering().isEmpty()) {
                    errorMsg = errorMsg + " has the following different entries: " + diff.entriesDiffering();
                }
                this.failWithRawMessage("Not true that %s is equal to <%s>. " + errorMsg, this.getDisplaySubject(), other);
            } else {
                this.fail("is equal to", other);
            }
        }
    }

    public void isEmpty() {
        if (!((Map)this.getSubject()).isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (((Map)this.getSubject()).isEmpty()) {
            this.fail("is not empty");
        }
    }

    public void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize (%s) must be >= 0", (Object[])new Object[]{expectedSize});
        int actualSize = ((Map)this.getSubject()).size();
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public void containsKey(@Nullable Object key) {
        if (!((Map)this.getSubject()).containsKey(key)) {
            this.fail("contains key", key);
        }
    }

    public void doesNotContainKey(@Nullable Object key) {
        if (((Map)this.getSubject()).containsKey(key)) {
            this.fail("does not contain key", key);
        }
    }

    public void containsEntry(@Nullable Object key, @Nullable Object value) {
        Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
        if (!((Map)this.getSubject()).entrySet().contains(entry)) {
            if (((Map)this.getSubject()).containsKey(key)) {
                this.failWithRawMessage("Not true that %s contains entry <%s>. However, it has a mapping from <%s> to <%s>", this.getDisplaySubject(), entry, key, ((Map)this.getSubject()).get(key));
            }
            if (((Map)this.getSubject()).containsValue(value)) {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry actualEntry : ((Map)this.getSubject()).entrySet()) {
                    if (!Objects.equal(actualEntry.getValue(), (Object)value)) continue;
                    keys.add(actualEntry.getKey());
                }
                this.failWithRawMessage("Not true that %s contains entry <%s>. However, the following keys are mapped to <%s>: %s", this.getDisplaySubject(), entry, value, keys);
            }
            this.fail("contains entry", (Object)entry);
        }
    }

    public void doesNotContainEntry(@Nullable Object key, @Nullable Object value) {
        Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
        if (((Map)this.getSubject()).entrySet().contains(entry)) {
            this.fail("does not contain entry", (Object)entry);
        }
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly() {
        return this.check().that(((Map)this.getSubject()).entrySet()).containsExactly(new Object[0]);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        Preconditions.checkArgument((rest.length % 2 == 0 ? 1 : 0) != 0, (String)"There must be an equal number of key/value pairs (i.e., the number of key/value parameters (%s) must be even).", (Object[])new Object[]{rest.length + 2});
        LinkedHashMap expectedMap = Maps.newLinkedHashMap();
        expectedMap.put(k0, v0);
        LinkedHashMultiset keys = LinkedHashMultiset.create();
        keys.add(k0);
        for (int i = 0; i < rest.length; i += 2) {
            Object key = rest[i];
            expectedMap.put(key, rest[i + 1]);
            keys.add(key);
        }
        Preconditions.checkArgument((keys.size() == expectedMap.size() ? 1 : 0) != 0, (String)"Duplicate keys (%s) cannot be passed to containsExactly().", (Object[])new Object[]{keys});
        return this.containsExactlyEntriesIn(expectedMap);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyEntriesIn(Map<?, ?> expectedMap) {
        return this.check().that(((Map)this.getSubject()).entrySet()).containsExactlyElementsIn(expectedMap.entrySet());
    }
}

