/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.MathUtil;
import javax.annotation.Nullable;

public final class DoubleSubject
extends ComparableSubject<DoubleSubject, Double> {
    private static final long NEG_ZERO_BITS = Double.doubleToLongBits(-0.0);

    DoubleSubject(FailureStrategy failureStrategy, @Nullable Double subject) {
        super(failureStrategy, subject);
    }

    public TolerantDoubleComparison isWithin(final double tolerance) {
        return new TolerantDoubleComparison(){

            @Override
            public void of(double expected) {
                Double actual = (Double)DoubleSubject.this.getSubject();
                Preconditions.checkNotNull((Object)actual, (String)"actual value cannot be null. tolerance=%s expected=%s", (Object[])new Object[]{tolerance, expected});
                DoubleSubject.checkTolerance(tolerance);
                if (!MathUtil.equalWithinTolerance(actual, expected, tolerance)) {
                    DoubleSubject.this.failWithRawMessage("%s and <%s> should have been finite values within <%s> of each other", DoubleSubject.this.getDisplaySubject(), expected, tolerance);
                }
            }
        };
    }

    public TolerantDoubleComparison isNotWithin(final double tolerance) {
        return new TolerantDoubleComparison(){

            @Override
            public void of(double expected) {
                Double actual = (Double)DoubleSubject.this.getSubject();
                Preconditions.checkNotNull((Object)actual, (String)"actual value cannot be null. tolerance=%s expected=%s", (Object[])new Object[]{tolerance, expected});
                DoubleSubject.checkTolerance(tolerance);
                if (!MathUtil.notEqualWithinTolerance(actual, expected, tolerance)) {
                    DoubleSubject.this.failWithRawMessage("%s and <%s> should have been finite values not within <%s> of each other", DoubleSubject.this.getDisplaySubject(), expected, tolerance);
                }
            }
        };
    }

    @Deprecated
    public final void isEqualTo(@Nullable Double other) {
        super.isEqualTo(other);
    }

    @Deprecated
    public final void isNotEqualTo(@Nullable Double other) {
        super.isNotEqualTo(other);
    }

    @Override
    @Deprecated
    public final void isEquivalentAccordingToCompareTo(Double other) {
        super.isEquivalentAccordingToCompareTo(other);
    }

    static void checkTolerance(double tolerance) {
        Preconditions.checkArgument((!Double.isNaN(tolerance) ? 1 : 0) != 0, (Object)"tolerance cannot be NaN");
        Preconditions.checkArgument((tolerance >= 0.0 ? 1 : 0) != 0, (String)"tolerance (%s) cannot be negative", (Object[])new Object[]{tolerance});
        Preconditions.checkArgument((Double.doubleToLongBits(tolerance) != NEG_ZERO_BITS ? 1 : 0) != 0, (String)"tolerance (%s) cannot be negative", (Object[])new Object[]{tolerance});
        Preconditions.checkArgument((tolerance != Double.POSITIVE_INFINITY ? 1 : 0) != 0, (Object)"tolerance cannot be POSITIVE_INFINITY");
    }

    public final void isPositiveInfinity() {
        super.isEqualTo(Double.POSITIVE_INFINITY);
    }

    public final void isNegativeInfinity() {
        super.isEqualTo(Double.NEGATIVE_INFINITY);
    }

    public final void isNaN() {
        super.isEqualTo(Double.NaN);
    }

    public final void isFinite() {
        if (this.getSubject() == null || ((Double)this.getSubject()).isNaN() || ((Double)this.getSubject()).isInfinite()) {
            this.failWithRawMessage("%s should have been finite", this.getDisplaySubject());
        }
    }

    public final void isNotNaN() {
        if (this.getSubject() == null || ((Double)this.getSubject()).isNaN()) {
            this.failWithRawMessage("%s should not have been NaN", this.getDisplaySubject());
        }
    }

    public abstract class TolerantDoubleComparison {
        private TolerantDoubleComparison() {
        }

        public abstract void of(double var1);

        @Deprecated
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("If you meant to compare doubles, use .of(double) instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

