/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.FailureContext;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.StringUtil;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import javax.annotation.Nullable;

public abstract class AbstractVerb<T extends AbstractVerb<T>>
extends FailureContext {
    private final FailureStrategy failureStrategy;

    public AbstractVerb(FailureStrategy failureStrategy) {
        this(failureStrategy, null, new Object[0]);
    }

    public AbstractVerb(FailureStrategy failureStrategy, @Nullable String format, Object ... args) {
        super(format, args);
        this.failureStrategy = (FailureStrategy)Preconditions.checkNotNull((Object)failureStrategy);
    }

    protected FailureStrategy getFailureStrategy() {
        return this.hasFailureMessage() ? new MessagePrependingFailureStrategy(this.failureStrategy, this) : this.failureStrategy;
    }

    public void fail() {
        this.getFailureStrategy().fail("");
    }

    public void fail(@Nullable String format, Object ... args) {
        this.getFailureStrategy().fail(StringUtil.format(format, args));
    }

    public abstract T withFailureMessage(@Nullable String var1);

    public abstract T withFailureMessage(@Nullable String var1, Object ... var2);

    public <S extends Subject<S, T>, T, SF extends SubjectFactory<S, T>> DelegatedVerb<S, T> about(SF factory) {
        return new DelegatedVerb(this.getFailureStrategy(), factory);
    }

    protected static class MessagePrependingFailureStrategy
    extends FailureStrategy {
        private final FailureStrategy delegate;
        private final FailureContext messageHolder;

        public MessagePrependingFailureStrategy(FailureStrategy delegate, FailureContext messageHolder) {
            this.delegate = (FailureStrategy)Preconditions.checkNotNull((Object)delegate);
            this.messageHolder = (FailureContext)Preconditions.checkNotNull((Object)messageHolder);
        }

        @Override
        public void fail(String message) {
            this.delegate.fail(this.prependFailureMessageIfAny(message));
        }

        @Override
        public void fail(String message, Throwable cause) {
            this.delegate.fail(this.prependFailureMessageIfAny(message), cause);
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual) {
            this.delegate.failComparing(this.prependFailureMessageIfAny(message), expected, actual);
        }

        private String prependFailureMessageIfAny(String message) {
            return this.messageHolder.getFailureMessage() == null ? message : this.messageHolder.getFailureMessage() + ": " + message;
        }
    }

    public static final class DelegatedVerb<S extends Subject<S, T>, T> {
        private final SubjectFactory<S, T> factory;
        private final FailureStrategy failureStrategy;

        public DelegatedVerb(FailureStrategy failureStrategy, SubjectFactory<S, T> factory) {
            this.factory = (SubjectFactory)Preconditions.checkNotNull(factory);
            this.failureStrategy = (FailureStrategy)Preconditions.checkNotNull((Object)failureStrategy);
        }

        public S that(T target) {
            return this.factory.getSubject(this.failureStrategy, target);
        }

        public DelegatedVerb<S, T> withFailureMessage(@Nullable String failureMessage) {
            return failureMessage == null ? this.withFailureMessage(null, new Object[0]) : this.withFailureMessage("%s", failureMessage);
        }

        public DelegatedVerb<S, T> withFailureMessage(@Nullable String format, Object ... args) {
            FailureContext holder = new FailureContext(format, args);
            return new DelegatedVerb<S, T>(new MessagePrependingFailureStrategy(this.failureStrategy, holder), this.factory);
        }
    }
}

