/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Platform;
import com.google.common.truth.Subject;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AbstractArraySubject<S extends AbstractArraySubject<S, T>, T>
extends Subject<S, T> {
    AbstractArraySubject(FailureStrategy failureStrategy, @Nullable T subject) {
        super(failureStrategy, subject);
    }

    public void isEmpty() {
        if (!this.listRepresentation().isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (this.listRepresentation().isEmpty()) {
            this.fail("is not empty");
        }
    }

    public void hasLength(int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length (%s) must be >= 0");
        if (this.listRepresentation().size() != length) {
            this.fail("has length", (Object)length);
        }
    }

    @Override
    public S named(String name) {
        return (S)((AbstractArraySubject)super.named(name));
    }

    abstract String underlyingType();

    abstract List<?> listRepresentation();

    @Override
    protected String getDisplaySubject() {
        return this.internalCustomName() == null ? "<(" + this.underlyingType() + this.brackets() + ") " + this.listRepresentation() + ">" : this.internalCustomName();
    }

    void failWithBadType(Object expected) {
        String expectedBrackets = "";
        Class<?> expectedType = expected.getClass();
        while (expectedType.isArray()) {
            expectedBrackets = expectedBrackets + "[]";
            expectedType = expectedType.getComponentType();
        }
        String expectedTypeString = expectedType.getName() + expectedBrackets;
        this.failWithRawMessage("Incompatible types compared. expected: %s, actual: %s%s", Platform.compressType(expectedTypeString), this.underlyingType(), this.brackets());
    }

    String brackets() {
        return "[]";
    }
}

