/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.common.truth.AbstractVerb;
import com.google.common.truth.BigDecimalSubject;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.ClassSubject;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.DefaultSubject;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.ListMultimapSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.MultimapSubject;
import com.google.common.truth.MultisetSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.OptionalSubject;
import com.google.common.truth.Platform;
import com.google.common.truth.PrimitiveBooleanArraySubject;
import com.google.common.truth.PrimitiveByteArraySubject;
import com.google.common.truth.PrimitiveCharArraySubject;
import com.google.common.truth.PrimitiveDoubleArraySubject;
import com.google.common.truth.PrimitiveFloatArraySubject;
import com.google.common.truth.PrimitiveIntArraySubject;
import com.google.common.truth.PrimitiveLongArraySubject;
import com.google.common.truth.SetMultimapSubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.TableSubject;
import com.google.common.truth.TestVerb;
import com.google.common.truth.ThrowableSubject;
import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public final class Truth {
    public static final FailureStrategy THROW_ASSERTION_ERROR = new FailureStrategy(){

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual) {
            throw Platform.comparisonFailure(message, expected.toString(), actual.toString());
        }
    };
    private static final TestVerb ASSERT = new TestVerb(THROW_ASSERTION_ERROR);

    public static TestVerb assert_() {
        return ASSERT;
    }

    public static TestVerb assertWithMessage(String messageToPrepend) {
        return Truth.assert_().withFailureMessage(messageToPrepend);
    }

    public static <S extends Subject<S, T>, T, SF extends SubjectFactory<S, T>> AbstractVerb.DelegatedVerb<S, T> assertAbout(SF factory) {
        return Truth.assert_().about(factory);
    }

    public static <T extends Comparable<?>> ComparableSubject<?, T> assertThat(@Nullable T target) {
        return Truth.assert_().that(target);
    }

    public static BigDecimalSubject assertThat(@Nullable BigDecimal target) {
        return Truth.assert_().that(target);
    }

    public static Subject<DefaultSubject, Object> assertThat(@Nullable Object target) {
        return Truth.assert_().that(target);
    }

    @GwtIncompatible(value="ClassSubject.java")
    public static ClassSubject assertThat(@Nullable Class<?> target) {
        return Truth.assert_().that(target);
    }

    public static ThrowableSubject assertThat(@Nullable Throwable target) {
        return Truth.assert_().that(target);
    }

    public static LongSubject assertThat(@Nullable Long target) {
        return Truth.assert_().that(target);
    }

    public static DoubleSubject assertThat(@Nullable Double target) {
        return Truth.assert_().that(target);
    }

    public static IntegerSubject assertThat(@Nullable Integer target) {
        return Truth.assert_().that(target);
    }

    public static BooleanSubject assertThat(@Nullable Boolean target) {
        return Truth.assert_().that(target);
    }

    public static StringSubject assertThat(@Nullable String target) {
        return Truth.assert_().that(target);
    }

    public static <T, C extends Iterable<T>> IterableSubject<? extends IterableSubject<?, T, C>, T, C> assertThat(@Nullable Iterable<T> target) {
        return Truth.assert_().that(target);
    }

    public static <T> ObjectArraySubject<T> assertThat(@Nullable T[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveBooleanArraySubject assertThat(@Nullable boolean[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveIntArraySubject assertThat(@Nullable int[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveLongArraySubject assertThat(@Nullable long[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveByteArraySubject assertThat(@Nullable byte[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveCharArraySubject assertThat(@Nullable char[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveFloatArraySubject assertThat(@Nullable float[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveDoubleArraySubject assertThat(@Nullable double[] target) {
        return Truth.assert_().that(target);
    }

    public static <T> OptionalSubject<T> assertThat(@Nullable Optional<T> target) {
        return Truth.assert_().that(target);
    }

    public static MapSubject assertThat(@Nullable Map<?, ?> target) {
        return Truth.assert_().that(target);
    }

    public static <K, V, M extends Multimap<K, V>> MultimapSubject<? extends MultimapSubject<?, K, V, M>, K, V, M> assertThat(@Nullable Multimap<K, V> target) {
        return Truth.assert_().that(target);
    }

    public static <K, V, M extends ListMultimap<K, V>> ListMultimapSubject<? extends ListMultimapSubject<?, K, V, M>, K, V, M> assertThat(@Nullable ListMultimap<K, V> target) {
        return Truth.assert_().that(target);
    }

    public static <K, V, M extends SetMultimap<K, V>> SetMultimapSubject<? extends SetMultimapSubject<?, K, V, M>, K, V, M> assertThat(@Nullable SetMultimap<K, V> target) {
        return Truth.assert_().that(target);
    }

    public static <E, M extends Multiset<E>> MultisetSubject<? extends MultisetSubject<?, E, M>, E, M> assertThat(@Nullable Multiset<E> target) {
        return Truth.assert_().that(target);
    }

    public static TableSubject assertThat(@Nullable Table<?, ?, ?> target) {
        return Truth.assert_().that(target);
    }
}

