/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import javax.annotation.Nullable;

public final class TableSubject
extends Subject<TableSubject, Table<?, ?, ?>> {
    TableSubject(FailureStrategy failureStrategy, @Nullable Table<?, ?, ?> table) {
        super(failureStrategy, table);
    }

    public void isEmpty() {
        if (!((Table)this.getSubject()).isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (((Table)this.getSubject()).isEmpty()) {
            this.fail("is not empty");
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (Object[])new Object[]{expectedSize});
        int actualSize = ((Table)this.getSubject()).size();
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public void contains(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (!((Table)this.getSubject()).contains(rowKey, columnKey)) {
            this.fail("contains mapping for row/column", rowKey, columnKey);
        }
    }

    public void doesNotContain(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (((Table)this.getSubject()).contains(rowKey, columnKey)) {
            this.fail("does not contain mapping for row/column", rowKey, columnKey);
        }
    }

    public void containsCell(@Nullable Object rowKey, @Nullable Object colKey, @Nullable Object value) {
        Table.Cell cell = Tables.immutableCell((Object)rowKey, (Object)colKey, (Object)value);
        if (!((Table)this.getSubject()).cellSet().contains(cell)) {
            this.fail("contains cell", (Object)cell);
        }
    }

    public void doesNotContainCell(@Nullable Object rowKey, @Nullable Object colKey, @Nullable Object value) {
        Table.Cell cell = Tables.immutableCell((Object)rowKey, (Object)colKey, (Object)value);
        if (((Table)this.getSubject()).cellSet().contains(cell)) {
            this.fail("does not contain cell", (Object)cell);
        }
    }

    public void containsRow(@Nullable Object rowKey) {
        if (!((Table)this.getSubject()).containsRow(rowKey)) {
            this.fail("contains row", rowKey);
        }
    }

    public void containsColumn(@Nullable Object columnKey) {
        if (!((Table)this.getSubject()).containsColumn(columnKey)) {
            this.fail("contains column", columnKey);
        }
    }

    public void containsValue(@Nullable Object value) {
        if (!((Table)this.getSubject()).containsValue(value)) {
            this.fail("contains value", value);
        }
    }
}

