/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Optional;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import javax.annotation.Nullable;

public class OptionalSubject<T>
extends Subject<OptionalSubject<T>, Optional<T>> {
    OptionalSubject(FailureStrategy failureStrategy, @Nullable Optional<T> subject) {
        super(failureStrategy, subject);
    }

    public void isPresent() {
        if (this.getSubject() == null || !((Optional)this.getSubject()).isPresent()) {
            this.failWithoutSubject("is present");
        }
    }

    public void isAbsent() {
        if (this.getSubject() == null || ((Optional)this.getSubject()).isPresent()) {
            this.fail("is absent");
        }
    }

    public void hasValue(Object expected) {
        if (expected == null) {
            throw new NullPointerException("Optional cannot have a null value.");
        }
        if (this.getSubject() == null || !((Optional)this.getSubject()).isPresent()) {
            this.fail("has value", expected);
        } else {
            Object actual = ((Optional)this.getSubject()).get();
            if (!actual.equals(expected)) {
                this.fail("has value", expected);
            }
        }
    }
}

