/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import javax.annotation.Nullable;

public final class MultisetSubject<S extends MultisetSubject<S, E, M>, E, M extends Multiset<E>>
extends IterableSubject<S, E, M> {
    private MultisetSubject(FailureStrategy failureStrategy, @Nullable M multiset) {
        super(failureStrategy, multiset);
    }

    static <E, M extends Multiset<E>> MultisetSubject<? extends MultisetSubject<?, E, M>, E, M> create(FailureStrategy failureStrategy, @Nullable Multiset<E> multiset) {
        return new MultisetSubject(failureStrategy, multiset);
    }

    public final void hasCount(@Nullable Object element, int expectedCount) {
        Preconditions.checkArgument((expectedCount >= 0 ? 1 : 0) != 0, (String)"expectedCount(%s) must be >= 0", (Object[])new Object[]{expectedCount});
        int actualCount = ((Multiset)this.getSubject()).count(element);
        if (actualCount != expectedCount) {
            String string = String.valueOf(String.valueOf(element));
            this.failWithBadResults(new StringBuilder(21 + string.length()).append("has a count for <").append(string).append("> of").toString(), expectedCount, "is", actualCount);
        }
    }
}

