/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class MultimapSubject<S extends MultimapSubject<S, K, V, M>, K, V, M extends Multimap<K, V>>
extends Subject<S, M> {
    MultimapSubject(FailureStrategy failureStrategy, @Nullable M multimap) {
        super(failureStrategy, multimap);
    }

    static <K, V, M extends Multimap<K, V>> MultimapSubject<? extends MultimapSubject<?, K, V, M>, K, V, M> create(FailureStrategy failureStrategy, @Nullable Multimap<K, V> multimap) {
        return new MultimapSubject(failureStrategy, multimap);
    }

    public void isEmpty() {
        if (!((Multimap)this.getSubject()).isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (((Multimap)this.getSubject()).isEmpty()) {
            this.fail("is not empty");
        }
    }

    public void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (Object[])new Object[]{expectedSize});
        int actualSize = ((Multimap)this.getSubject()).size();
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public void containsKey(@Nullable Object key) {
        if (!((Multimap)this.getSubject()).containsKey(key)) {
            this.fail("contains key", key);
        }
    }

    public void doesNotContainKey(@Nullable Object key) {
        if (((Multimap)this.getSubject()).containsKey(key)) {
            this.fail("does not contain key", key);
        }
    }

    public void containsEntry(@Nullable Object key, @Nullable Object value) {
        if (!((Multimap)this.getSubject()).containsEntry(key, value)) {
            this.fail("contains entry", (Object)Maps.immutableEntry((Object)key, (Object)value));
        }
    }

    public void doesNotContainEntry(@Nullable Object key, @Nullable Object value) {
        if (((Multimap)this.getSubject()).containsEntry(key, value)) {
            this.fail("does not contain entry", (Object)Maps.immutableEntry((Object)key, (Object)value));
        }
    }

    @CheckReturnValue
    public IterableSubject<? extends IterableSubject<?, V, ? extends Collection<V>>, V, ? extends Collection<V>> valuesForKey(@Nullable K key) {
        return new IterableValuesForKey(this.failureStrategy, this, key);
    }

    @Override
    public void isEqualTo(@Nullable Object other) {
        if (!Objects.equal(this.getSubject(), (Object)other)) {
            if (this.getSubject() instanceof ListMultimap && other instanceof SetMultimap || this.getSubject() instanceof SetMultimap && other instanceof ListMultimap) {
                String mapType1 = this.getSubject() instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
                String mapType2 = other instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
                this.failWithRawMessage("Not true that %s %s is equal to %s <%s>. A %s cannot equal a %s if either is non-empty.", mapType1, this.getDisplaySubject(), mapType2, other, mapType1, mapType2);
            } else {
                this.fail("is equal to", other);
            }
        }
    }

    public Ordered containsExactly(Multimap<?, ?> expectedMultimap) {
        Preconditions.checkNotNull(expectedMultimap, (Object)"expectedMultimap");
        return this.containsExactly("contains exactly", expectedMultimap);
    }

    private Ordered containsExactly(String failVerb, Multimap<?, ?> expectedMultimap) {
        Multimap<?, ?> missing = MultimapSubject.difference(expectedMultimap, (Multimap)this.getSubject());
        Multimap<?, ?> extra = MultimapSubject.difference((Multimap)this.getSubject(), expectedMultimap);
        if (!missing.isEmpty()) {
            if (!extra.isEmpty()) {
                this.failWithRawMessage("Not true that %s %s <%s>. It is missing <%s> and has unexpected items <%s>", this.getDisplaySubject(), failVerb, expectedMultimap, MultimapSubject.countDuplicatesMultimap(missing), MultimapSubject.countDuplicatesMultimap(extra));
            } else {
                this.failWithBadResults(failVerb, expectedMultimap, "is missing", MultimapSubject.countDuplicatesMultimap(missing));
            }
        } else if (!extra.isEmpty()) {
            this.failWithBadResults(failVerb, expectedMultimap, "has unexpected items", MultimapSubject.countDuplicatesMultimap(extra));
        }
        return new MultimapInOrder(expectedMultimap);
    }

    private static <K, V> Collection<V> get(Multimap<K, V> multimap, @Nullable Object key) {
        if (multimap.containsKey(key)) {
            return multimap.get(key);
        }
        return Collections.emptyList();
    }

    private static Multimap<?, ?> difference(Multimap<?, ?> minuend, Multimap<?, ?> subtrahend) {
        LinkedListMultimap difference = LinkedListMultimap.create();
        for (Object key : minuend.keySet()) {
            List<?> valDifference = MultimapSubject.difference(Lists.newArrayList(MultimapSubject.get(minuend, key)), Lists.newArrayList(MultimapSubject.get(subtrahend, key)));
            difference.putAll(key, valDifference);
        }
        return difference;
    }

    private static List<?> difference(List<?> minuend, List<?> subtrahend) {
        LinkedHashMultiset remaining = LinkedHashMultiset.create(subtrahend);
        ArrayList difference = Lists.newArrayList();
        for (Object elem : minuend) {
            if (remaining.remove(elem)) continue;
            difference.add(elem);
        }
        return difference;
    }

    private static <K, V> String countDuplicatesMultimap(Multimap<K, V> multimap) {
        ArrayList<String> entries = new ArrayList<String>();
        for (Object key : multimap.keySet()) {
            String string = String.valueOf(String.valueOf(key));
            String string2 = String.valueOf(String.valueOf(SubjectUtils.countDuplicates(multimap.get(key))));
            entries.add(new StringBuilder(1 + string.length() + string2.length()).append(string).append("=").append(string2).toString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Joiner.on((String)", ").appendTo(sb, entries);
        sb.append("}");
        return sb.toString();
    }

    private class MultimapInOrder
    implements Ordered {
        private final Multimap<?, ?> expectedMultimap;

        MultimapInOrder(Multimap<?, ?> expectedMultimap) {
            this.expectedMultimap = expectedMultimap;
        }

        @Override
        public void inOrder() {
            boolean keysInOrder = Lists.newArrayList((Iterable)((Multimap)MultimapSubject.this.getSubject()).keySet()).equals(Lists.newArrayList((Iterable)this.expectedMultimap.keySet()));
            LinkedHashSet keysWithValuesOutOfOrder = Sets.newLinkedHashSet();
            LinkedHashSet allKeys = Sets.newLinkedHashSet();
            allKeys.addAll(((Multimap)MultimapSubject.this.getSubject()).keySet());
            allKeys.addAll(this.expectedMultimap.keySet());
            for (Object key : allKeys) {
                ArrayList expectedVals;
                ArrayList actualVals = Lists.newArrayList((Iterable)MultimapSubject.get((Multimap)MultimapSubject.this.getSubject(), key));
                if (actualVals.equals(expectedVals = Lists.newArrayList((Iterable)MultimapSubject.get(this.expectedMultimap, key)))) continue;
                keysWithValuesOutOfOrder.add(key);
            }
            if (!keysInOrder) {
                if (!keysWithValuesOutOfOrder.isEmpty()) {
                    MultimapSubject.this.failWithRawMessage("Not true that %s contains exactly <%s> in order. The keys are not in order, and the values for keys <%s> are not in order either", MultimapSubject.this.getDisplaySubject(), this.expectedMultimap, keysWithValuesOutOfOrder);
                } else {
                    MultimapSubject.this.failWithRawMessage("Not true that %s contains exactly <%s> in order. The keys are not in order", MultimapSubject.this.getDisplaySubject(), this.expectedMultimap);
                }
            } else if (!keysWithValuesOutOfOrder.isEmpty()) {
                MultimapSubject.this.failWithRawMessage("Not true that %s contains exactly <%s> in order. The values for keys <%s> are not in order", MultimapSubject.this.getDisplaySubject(), this.expectedMultimap, keysWithValuesOutOfOrder);
            }
        }
    }

    private class IterableValuesForKey
    extends IterableSubject<IterableValuesForKey, V, Collection<V>> {
        @Nullable
        private final K key;
        @Nullable
        private final String display;

        IterableValuesForKey(FailureStrategy failureStrategy, @Nullable MultimapSubject<?, K, V, ?> multimapSubject2, K key) {
            super(failureStrategy, ((Multimap)multimapSubject2.getSubject()).get(key));
            this.key = key;
            this.display = multimapSubject2.getDisplaySubject();
        }

        @Override
        protected String getDisplaySubject() {
            String string = String.valueOf(String.valueOf(this.key));
            String string2 = String.valueOf(String.valueOf(this.getSubject()));
            String string3 = String.valueOf(String.valueOf(this.display));
            String innerDisplaySubject = new StringBuilder(28 + string.length() + string2.length() + string3.length()).append("<Values for key <").append(string).append("> (<").append(string2).append(">) in ").append(string3).append(">").toString();
            if (this.internalCustomName() != null) {
                String string4 = String.valueOf(String.valueOf(this.internalCustomName()));
                String string5 = String.valueOf(String.valueOf(innerDisplaySubject));
                return new StringBuilder(3 + string4.length() + string5.length()).append(string4).append(" (").append(string5).append(")").toString();
            }
            return innerDisplaySubject;
        }
    }
}

