/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.jimfs.AttributeService;
import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Directory;
import com.google.common.jimfs.File;
import com.google.common.jimfs.FileFactory;
import com.google.common.jimfs.FileSystemState;
import com.google.common.jimfs.FileSystemView;
import com.google.common.jimfs.FileTree;
import com.google.common.jimfs.HeapDisk;
import com.google.common.jimfs.JimfsFileStore;
import com.google.common.jimfs.JimfsFileSystem;
import com.google.common.jimfs.JimfsFileSystemProvider;
import com.google.common.jimfs.JimfsPath;
import com.google.common.jimfs.Name;
import com.google.common.jimfs.PathService;
import java.io.IOException;
import java.net.URI;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;

final class JimfsFileSystems {
    private JimfsFileSystems() {
    }

    public static JimfsFileSystem newFileSystem(JimfsFileSystemProvider provider, URI uri, Configuration config) throws IOException {
        PathService pathService = new PathService(config);
        FileSystemState state = new FileSystemState(JimfsFileSystemProvider.removeFileSystemRunnable(uri));
        JimfsFileStore fileStore = JimfsFileSystems.createFileStore(config, pathService, state);
        FileSystemView defaultView = JimfsFileSystems.createDefaultView(config, fileStore, pathService);
        JimfsFileSystem fileSystem = new JimfsFileSystem(provider, uri, fileStore, pathService, defaultView);
        pathService.setFileSystem(fileSystem);
        return fileSystem;
    }

    private static JimfsFileStore createFileStore(Configuration config, PathService pathService, FileSystemState state) {
        AttributeService attributeService = new AttributeService(config);
        HeapDisk disk = new HeapDisk(config);
        FileFactory fileFactory = new FileFactory(disk);
        HashMap<Name, File> roots = new HashMap<Name, File>();
        for (String root : config.roots) {
            JimfsPath path = pathService.parsePath(root, new String[0]);
            if (!path.isAbsolute() && path.getNameCount() == 0) {
                String string = String.valueOf(root);
                throw new IllegalArgumentException(string.length() != 0 ? "Invalid root path: ".concat(string) : new String("Invalid root path: "));
            }
            Name rootName = path.root();
            Directory rootDir = fileFactory.createRootDirectory(rootName);
            attributeService.setInitialAttributes(rootDir, new FileAttribute[0]);
            roots.put(rootName, rootDir);
        }
        return new JimfsFileStore(new FileTree(roots), fileFactory, disk, attributeService, config.supportedFeatures, state);
    }

    private static FileSystemView createDefaultView(Configuration config, JimfsFileStore fileStore, PathService pathService) throws IOException {
        JimfsPath workingDirPath = pathService.parsePath(config.workingDirectory, new String[0]);
        Directory dir = fileStore.getRoot(workingDirPath.root());
        if (dir == null) {
            String string = String.valueOf(String.valueOf(workingDirPath));
            throw new IllegalArgumentException(new StringBuilder(26 + string.length()).append("Invalid working dir path: ").append(string).toString());
        }
        for (Name name : workingDirPath.names()) {
            Directory newDir = (Directory)fileStore.directoryCreator().get();
            fileStore.setInitialAttributes(newDir, new FileAttribute[0]);
            dir.link(name, newDir);
            dir = newDir;
        }
        return new FileSystemView(fileStore, dir, workingDirPath);
    }
}

