/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.base.Preconditions;
import com.google.common.jimfs.FileSystemState;
import com.google.common.jimfs.JimfsAsynchronousFileChannel;
import com.google.common.jimfs.RegularFile;
import com.google.common.jimfs.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

final class JimfsFileChannel
extends FileChannel {
    @Nullable
    private volatile Thread blockingThread;
    private final RegularFile file;
    private final FileSystemState fileSystemState;
    private final boolean read;
    private final boolean write;
    private final boolean append;
    private long position;

    public JimfsFileChannel(RegularFile file, Set<OpenOption> options, FileSystemState fileSystemState) {
        this.file = file;
        this.fileSystemState = fileSystemState;
        this.read = options.contains(StandardOpenOption.READ);
        this.write = options.contains(StandardOpenOption.WRITE);
        this.append = options.contains(StandardOpenOption.APPEND);
        fileSystemState.register(this);
    }

    public AsynchronousFileChannel asAsynchronousFileChannel(ExecutorService executor) {
        return new JimfsAsynchronousFileChannel(this, executor);
    }

    void checkReadable() {
        if (!this.read) {
            throw new NonReadableChannelException();
        }
    }

    void checkWritable() {
        if (!this.write) {
            throw new NonWritableChannelException();
        }
    }

    void checkOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private void beginBlocking() {
        this.begin();
        this.blockingThread = Thread.currentThread();
    }

    private void endBlocking(boolean completed) throws AsynchronousCloseException {
        this.blockingThread = null;
        this.end(completed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        Preconditions.checkNotNull((Object)dst);
        this.checkOpen();
        this.checkReadable();
        JimfsFileChannel jimfsFileChannel = this;
        synchronized (jimfsFileChannel) {
            boolean completed;
            block12: {
                completed = false;
                this.beginBlocking();
                if (this.isOpen()) break block12;
                int n = 0;
                this.endBlocking(completed);
                return n;
            }
            this.file.readLock().lockInterruptibly();
            int read = this.file.read(this.position, dst);
            if (read != -1) {
                this.position += (long)read;
            }
            this.file.updateAccessTime();
            completed = true;
            int n = read;
            this.file.readLock().unlock();
            this.endBlocking(completed);
            return n;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            this.file.readLock().unlock();
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            this.endBlocking(completed);
                        }
                    }
                    catch (Throwable throwable2) {
                        this.endBlocking(completed);
                        throw throwable2;
                    }
                }
            }
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        Preconditions.checkPositionIndexes((int)offset, (int)(offset + length), (int)dsts.length);
        List<ByteBuffer> buffers = Arrays.asList(dsts).subList(offset, offset + length);
        Util.checkNoneNull(buffers);
        this.checkOpen();
        this.checkReadable();
        JimfsFileChannel jimfsFileChannel = this;
        synchronized (jimfsFileChannel) {
            boolean completed;
            block12: {
                completed = false;
                this.beginBlocking();
                if (this.isOpen()) break block12;
                long l = 0L;
                this.endBlocking(completed);
                return l;
            }
            this.file.readLock().lockInterruptibly();
            long read = this.file.read(this.position, buffers);
            if (read != -1L) {
                this.position += read;
            }
            this.file.updateAccessTime();
            completed = true;
            long l = read;
            this.file.readLock().unlock();
            this.endBlocking(completed);
            return l;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            this.file.readLock().unlock();
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            this.endBlocking(completed);
                        }
                    }
                    catch (Throwable throwable2) {
                        this.endBlocking(completed);
                        throw throwable2;
                    }
                }
            }
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        Preconditions.checkNotNull((Object)src);
        this.checkOpen();
        this.checkWritable();
        JimfsFileChannel jimfsFileChannel = this;
        synchronized (jimfsFileChannel) {
            boolean completed;
            block12: {
                completed = false;
                this.beginBlocking();
                if (this.isOpen()) break block12;
                int n = 0;
                this.endBlocking(completed);
                return n;
            }
            this.file.writeLock().lockInterruptibly();
            if (this.append) {
                this.position = this.file.size();
            }
            int written = this.file.write(this.position, src);
            this.position += (long)written;
            this.file.updateModifiedTime();
            completed = true;
            int n = written;
            this.file.writeLock().unlock();
            this.endBlocking(completed);
            return n;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            this.file.writeLock().unlock();
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            this.endBlocking(completed);
                        }
                    }
                    catch (Throwable throwable2) {
                        this.endBlocking(completed);
                        throw throwable2;
                    }
                }
            }
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        Preconditions.checkPositionIndexes((int)offset, (int)(offset + length), (int)srcs.length);
        List<ByteBuffer> buffers = Arrays.asList(srcs).subList(offset, offset + length);
        Util.checkNoneNull(buffers);
        this.checkOpen();
        this.checkWritable();
        JimfsFileChannel jimfsFileChannel = this;
        synchronized (jimfsFileChannel) {
            boolean completed;
            block12: {
                completed = false;
                this.beginBlocking();
                if (this.isOpen()) break block12;
                long l = 0L;
                this.endBlocking(completed);
                return l;
            }
            this.file.writeLock().lockInterruptibly();
            if (this.append) {
                this.position = this.file.size();
            }
            long written = this.file.write(this.position, buffers);
            this.position += written;
            this.file.updateModifiedTime();
            completed = true;
            long l = written;
            this.file.writeLock().unlock();
            this.endBlocking(completed);
            return l;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            this.file.writeLock().unlock();
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            this.endBlocking(completed);
                        }
                    }
                    catch (Throwable throwable2) {
                        this.endBlocking(completed);
                        throw throwable2;
                    }
                }
            }
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        this.checkOpen();
        JimfsFileChannel jimfsFileChannel = this;
        synchronized (jimfsFileChannel) {
            return this.position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel position(long newPosition) throws IOException {
        Util.checkNotNegative(newPosition, "newPosition");
        this.checkOpen();
        JimfsFileChannel jimfsFileChannel = this;
        synchronized (jimfsFileChannel) {
            this.position = newPosition;
        }
        return this;
    }

    @Override
    public long size() throws IOException {
        this.checkOpen();
        return this.file.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileChannel truncate(long size) throws IOException {
        Util.checkNotNegative(size, "size");
        this.checkOpen();
        this.checkWritable();
        JimfsFileChannel jimfsFileChannel = this;
        synchronized (jimfsFileChannel) {
            boolean completed;
            block12: {
                completed = false;
                this.beginBlocking();
                if (this.isOpen()) break block12;
                JimfsFileChannel jimfsFileChannel2 = this;
                this.endBlocking(completed);
                return jimfsFileChannel2;
            }
            this.file.writeLock().lockInterruptibly();
            this.file.truncate(size);
            if (this.position > size) {
                this.position = size;
            }
            this.file.updateModifiedTime();
            completed = true;
            JimfsFileChannel jimfsFileChannel3 = this;
            this.file.writeLock().unlock();
            this.endBlocking(completed);
            return jimfsFileChannel3;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            this.file.writeLock().unlock();
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            this.endBlocking(completed);
                        }
                    }
                    catch (Throwable throwable2) {
                        this.endBlocking(completed);
                        throw throwable2;
                    }
                }
            }
            throw new AssertionError();
        }
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.checkOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        Preconditions.checkNotNull((Object)target);
        Util.checkNotNegative(position, "position");
        Util.checkNotNegative(count, "count");
        this.checkOpen();
        this.checkReadable();
        JimfsFileChannel jimfsFileChannel = this;
        synchronized (jimfsFileChannel) {
            boolean completed;
            block11: {
                completed = false;
                this.beginBlocking();
                if (this.isOpen()) break block11;
                long l = 0L;
                this.endBlocking(completed);
                return l;
            }
            this.file.readLock().lockInterruptibly();
            long transferred = this.file.transferTo(position, count, target);
            this.file.updateAccessTime();
            completed = true;
            long l = transferred;
            this.file.readLock().unlock();
            this.endBlocking(completed);
            return l;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            this.file.readLock().unlock();
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            this.endBlocking(completed);
                        }
                    }
                    catch (Throwable throwable2) {
                        this.endBlocking(completed);
                        throw throwable2;
                    }
                }
            }
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        Preconditions.checkNotNull((Object)src);
        Util.checkNotNegative(position, "position");
        Util.checkNotNegative(count, "count");
        this.checkOpen();
        this.checkWritable();
        JimfsFileChannel jimfsFileChannel = this;
        synchronized (jimfsFileChannel) {
            boolean completed;
            block13: {
                completed = false;
                this.beginBlocking();
                if (this.isOpen()) break block13;
                long l = 0L;
                this.endBlocking(completed);
                return l;
            }
            this.file.writeLock().lockInterruptibly();
            if (this.append) {
                position = this.file.size();
            }
            long transferred = this.file.transferFrom(src, position, count);
            if (this.append) {
                this.position = position + transferred;
            }
            this.file.updateModifiedTime();
            completed = true;
            long l = transferred;
            this.file.writeLock().unlock();
            this.endBlocking(completed);
            return l;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            this.file.writeLock().unlock();
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            this.endBlocking(completed);
                        }
                    }
                    catch (Throwable throwable2) {
                        this.endBlocking(completed);
                        throw throwable2;
                    }
                }
            }
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        Preconditions.checkNotNull((Object)dst);
        Util.checkNotNegative(position, "position");
        this.checkOpen();
        this.checkReadable();
        JimfsFileChannel jimfsFileChannel = this;
        synchronized (jimfsFileChannel) {
            boolean completed;
            block11: {
                completed = false;
                this.beginBlocking();
                if (this.isOpen()) break block11;
                int n = 0;
                this.endBlocking(completed);
                return n;
            }
            this.file.readLock().lockInterruptibly();
            int read = this.file.read(position, dst);
            this.file.updateAccessTime();
            completed = true;
            int n = read;
            this.file.readLock().unlock();
            this.endBlocking(completed);
            return n;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            this.file.readLock().unlock();
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            this.endBlocking(completed);
                        }
                    }
                    catch (Throwable throwable2) {
                        this.endBlocking(completed);
                        throw throwable2;
                    }
                }
            }
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        Preconditions.checkNotNull((Object)src);
        Util.checkNotNegative(position, "position");
        this.checkOpen();
        this.checkWritable();
        JimfsFileChannel jimfsFileChannel = this;
        synchronized (jimfsFileChannel) {
            boolean completed;
            block13: {
                completed = false;
                this.beginBlocking();
                if (this.isOpen()) break block13;
                int n = 0;
                this.endBlocking(completed);
                return n;
            }
            this.file.writeLock().lockInterruptibly();
            if (this.append) {
                position = this.file.sizeWithoutLocking();
            }
            int written = this.file.write(position, src);
            if (this.append) {
                this.position = position + (long)written;
            }
            this.file.updateModifiedTime();
            completed = true;
            int n = written;
            this.file.writeLock().unlock();
            this.endBlocking(completed);
            return n;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            this.file.writeLock().unlock();
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            this.endBlocking(completed);
                        }
                    }
                    catch (Throwable throwable2) {
                        this.endBlocking(completed);
                        throw throwable2;
                    }
                }
            }
            throw new AssertionError();
        }
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        Util.checkNotNegative(position, "position");
        Util.checkNotNegative(size, "size");
        this.checkOpen();
        if (shared) {
            this.checkReadable();
        } else {
            this.checkWritable();
        }
        return new FakeFileLock(this, position, size, shared);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.lock(position, size, shared);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseChannel() {
        try {
            Thread thread = this.blockingThread;
            if (thread != null) {
                thread.interrupt();
            }
        }
        finally {
            this.fileSystemState.unregister(this);
            this.file.closed();
        }
    }

    static final class FakeFileLock
    extends FileLock {
        private final AtomicBoolean valid = new AtomicBoolean(true);

        public FakeFileLock(FileChannel channel, long position, long size, boolean shared) {
            super(channel, position, size, shared);
        }

        public FakeFileLock(AsynchronousFileChannel channel, long position, long size, boolean shared) {
            super(channel, position, size, shared);
        }

        @Override
        public boolean isValid() {
            return this.valid.get();
        }

        @Override
        public void release() throws IOException {
            this.valid.set(false);
        }
    }
}

