/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.jimfs.Configuration;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.UUID;

public final class Jimfs {
    public static final String URI_SCHEME = "jimfs";
    public static final String CONFIG_KEY = "config";

    private Jimfs() {
    }

    public static FileSystem newFileSystem() {
        return Jimfs.newFileSystem(Jimfs.newRandomFileSystemName());
    }

    public static FileSystem newFileSystem(String name) {
        String os = System.getProperty("os.name");
        Configuration config = os.contains("Windows") ? Configuration.windows() : (os.contains("OS X") ? Configuration.osX() : Configuration.unix());
        return Jimfs.newFileSystem(name, config);
    }

    public static FileSystem newFileSystem(Configuration configuration) {
        return Jimfs.newFileSystem(Jimfs.newRandomFileSystemName(), configuration);
    }

    public static FileSystem newFileSystem(String name, Configuration configuration) {
        try {
            URI uri = new URI(URI_SCHEME, name, null, null);
            return Jimfs.newFileSystem(uri, configuration);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @VisibleForTesting
    static FileSystem newFileSystem(URI uri, Configuration config) {
        Preconditions.checkArgument((boolean)URI_SCHEME.equals(uri.getScheme()), (String)"uri (%s) must have scheme %s", (Object[])new Object[]{uri, URI_SCHEME});
        ImmutableMap env = ImmutableMap.of((Object)CONFIG_KEY, (Object)config);
        try {
            return FileSystems.newFileSystem(uri, env, Jimfs.class.getClassLoader());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String newRandomFileSystemName() {
        return UUID.randomUUID().toString();
    }
}

