/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.jimfs.AttributeProvider;
import com.google.common.jimfs.Feature;
import com.google.common.jimfs.PathNormalization;
import com.google.common.jimfs.PathType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class Configuration {
    final PathType pathType;
    final ImmutableSet<PathNormalization> nameDisplayNormalization;
    final ImmutableSet<PathNormalization> nameCanonicalNormalization;
    final boolean pathEqualityUsesCanonicalForm;
    final int blockSize;
    final long maxSize;
    final long maxCacheSize;
    final ImmutableSet<String> attributeViews;
    final ImmutableSet<AttributeProvider> attributeProviders;
    final ImmutableMap<String, Object> defaultAttributeValues;
    final ImmutableSet<String> roots;
    final String workingDirectory;
    final ImmutableSet<Feature> supportedFeatures;

    public static Configuration unix() {
        return UnixHolder.UNIX;
    }

    public static Configuration osX() {
        return OsxHolder.OS_X;
    }

    public static Configuration windows() {
        return WindowsHolder.WINDOWS;
    }

    public static Builder builder(PathType pathType) {
        return new Builder(pathType);
    }

    private Configuration(Builder builder) {
        this.pathType = builder.pathType;
        this.nameDisplayNormalization = builder.nameDisplayNormalization;
        this.nameCanonicalNormalization = builder.nameCanonicalNormalization;
        this.pathEqualityUsesCanonicalForm = builder.pathEqualityUsesCanonicalForm;
        this.blockSize = builder.blockSize;
        this.maxSize = builder.maxSize;
        this.maxCacheSize = builder.maxCacheSize;
        this.attributeViews = builder.attributeViews;
        this.attributeProviders = builder.attributeProviders == null ? ImmutableSet.of() : ImmutableSet.copyOf((Collection)builder.attributeProviders);
        this.defaultAttributeValues = builder.defaultAttributeValues == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)builder.defaultAttributeValues);
        this.roots = builder.roots;
        this.workingDirectory = builder.workingDirectory;
        this.supportedFeatures = builder.supportedFeatures;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        public static final int DEFAULT_BLOCK_SIZE = 8192;
        public static final long DEFAULT_MAX_SIZE = 0x100000000L;
        public static final long DEFAULT_MAX_CACHE_SIZE = -1L;
        private final PathType pathType;
        private ImmutableSet<PathNormalization> nameDisplayNormalization = ImmutableSet.of();
        private ImmutableSet<PathNormalization> nameCanonicalNormalization = ImmutableSet.of();
        private boolean pathEqualityUsesCanonicalForm = false;
        private int blockSize = 8192;
        private long maxSize = 0x100000000L;
        private long maxCacheSize = -1L;
        private ImmutableSet<String> attributeViews = ImmutableSet.of();
        private Set<AttributeProvider> attributeProviders = null;
        private Map<String, Object> defaultAttributeValues;
        private ImmutableSet<String> roots = ImmutableSet.of();
        private String workingDirectory;
        private ImmutableSet<Feature> supportedFeatures = ImmutableSet.of();
        private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("[^:]+:[^:]+");

        private Builder(PathType pathType) {
            this.pathType = (PathType)Preconditions.checkNotNull((Object)pathType);
        }

        private Builder(Configuration configuration) {
            this.pathType = configuration.pathType;
            this.nameDisplayNormalization = configuration.nameDisplayNormalization;
            this.nameCanonicalNormalization = configuration.nameCanonicalNormalization;
            this.pathEqualityUsesCanonicalForm = configuration.pathEqualityUsesCanonicalForm;
            this.blockSize = configuration.blockSize;
            this.maxSize = configuration.maxSize;
            this.maxCacheSize = configuration.maxCacheSize;
            this.attributeViews = configuration.attributeViews;
            this.attributeProviders = configuration.attributeProviders.isEmpty() ? null : new HashSet<AttributeProvider>((Collection<AttributeProvider>)configuration.attributeProviders);
            this.defaultAttributeValues = configuration.defaultAttributeValues.isEmpty() ? null : new HashMap<String, Object>((Map<String, Object>)configuration.defaultAttributeValues);
            this.roots = configuration.roots;
            this.workingDirectory = configuration.workingDirectory;
            this.supportedFeatures = configuration.supportedFeatures;
        }

        public Builder setNameDisplayNormalization(PathNormalization first, PathNormalization ... more) {
            this.nameDisplayNormalization = this.checkNormalizations(Lists.asList((Object)((Object)first), (Object[])more));
            return this;
        }

        public Builder setNameCanonicalNormalization(PathNormalization first, PathNormalization ... more) {
            this.nameCanonicalNormalization = this.checkNormalizations(Lists.asList((Object)((Object)first), (Object[])more));
            return this;
        }

        private ImmutableSet<PathNormalization> checkNormalizations(List<PathNormalization> normalizations) {
            PathNormalization none = null;
            PathNormalization normalization = null;
            PathNormalization caseFold = null;
            block5: for (PathNormalization n : normalizations) {
                Preconditions.checkNotNull((Object)((Object)n));
                Builder.checkNormalizationNotSet(n, none);
                switch (n) {
                    case NONE: {
                        none = n;
                        continue block5;
                    }
                    case NFC: 
                    case NFD: {
                        Builder.checkNormalizationNotSet(n, normalization);
                        normalization = n;
                        continue block5;
                    }
                    case CASE_FOLD_UNICODE: 
                    case CASE_FOLD_ASCII: {
                        Builder.checkNormalizationNotSet(n, caseFold);
                        caseFold = n;
                        continue block5;
                    }
                }
                throw new AssertionError();
            }
            if (none != null) {
                return ImmutableSet.of();
            }
            return Sets.immutableEnumSet(normalizations);
        }

        private static void checkNormalizationNotSet(PathNormalization n, @Nullable PathNormalization set) {
            if (set != null) {
                String string = String.valueOf(String.valueOf((Object)n));
                String string2 = String.valueOf(String.valueOf((Object)set));
                throw new IllegalArgumentException(new StringBuilder(52 + string.length() + string2.length()).append("can't set normalization ").append(string).append(": normalization ").append(string2).append(" already set").toString());
            }
        }

        public Builder setPathEqualityUsesCanonicalForm(boolean useCanonicalForm) {
            this.pathEqualityUsesCanonicalForm = useCanonicalForm;
            return this;
        }

        public Builder setBlockSize(int blockSize) {
            Preconditions.checkArgument((blockSize > 0 ? 1 : 0) != 0, (String)"blockSize (%s) must be positive", (Object[])new Object[]{blockSize});
            this.blockSize = blockSize;
            return this;
        }

        public Builder setMaxSize(long maxSize) {
            Preconditions.checkArgument((maxSize > 0L ? 1 : 0) != 0, (String)"maxSize (%s) must be positive", (Object[])new Object[]{maxSize});
            this.maxSize = maxSize;
            return this;
        }

        public Builder setMaxCacheSize(long maxCacheSize) {
            Preconditions.checkArgument((maxCacheSize >= 0L ? 1 : 0) != 0, (String)"maxCacheSize (%s) may not be negative", (Object[])new Object[]{maxCacheSize});
            this.maxCacheSize = maxCacheSize;
            return this;
        }

        public Builder setAttributeViews(String first, String ... more) {
            this.attributeViews = ImmutableSet.copyOf((Collection)Lists.asList((Object)first, (Object[])more));
            return this;
        }

        public Builder addAttributeProvider(AttributeProvider provider) {
            Preconditions.checkNotNull((Object)provider);
            if (this.attributeProviders == null) {
                this.attributeProviders = new HashSet<AttributeProvider>();
            }
            this.attributeProviders.add(provider);
            return this;
        }

        public Builder setDefaultAttributeValue(String attribute, Object value) {
            Preconditions.checkArgument((boolean)ATTRIBUTE_PATTERN.matcher(attribute).matches(), (String)"attribute (%s) must be of the form \"view:attribute\"", (Object[])new Object[]{attribute});
            Preconditions.checkNotNull((Object)value);
            if (this.defaultAttributeValues == null) {
                this.defaultAttributeValues = new HashMap<String, Object>();
            }
            this.defaultAttributeValues.put(attribute, value);
            return this;
        }

        public Builder setRoots(String first, String ... more) {
            List roots = Lists.asList((Object)first, (Object[])more);
            for (String root : roots) {
                PathType.ParseResult parseResult = this.pathType.parsePath(root);
                Preconditions.checkArgument((boolean)parseResult.isRoot(), (String)"invalid root: %s", (Object[])new Object[]{root});
            }
            this.roots = ImmutableSet.copyOf((Collection)roots);
            return this;
        }

        public Builder setWorkingDirectory(String workingDirectory) {
            PathType.ParseResult parseResult = this.pathType.parsePath(workingDirectory);
            Preconditions.checkArgument((boolean)parseResult.isAbsolute(), (String)"working directory must be an absolute path: %s", (Object[])new Object[]{workingDirectory});
            this.workingDirectory = (String)Preconditions.checkNotNull((Object)workingDirectory);
            return this;
        }

        public Builder setSupportedFeatures(Feature ... features) {
            this.supportedFeatures = Sets.immutableEnumSet(Arrays.asList(features));
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }

    private static final class WindowsHolder {
        private static final Configuration WINDOWS = Configuration.builder(PathType.windows()).setRoots("C:\\", new String[0]).setWorkingDirectory("C:\\work").setNameCanonicalNormalization(PathNormalization.CASE_FOLD_ASCII, new PathNormalization[0]).setPathEqualityUsesCanonicalForm(true).setAttributeViews("basic", new String[0]).setSupportedFeatures(Feature.LINKS, Feature.SYMBOLIC_LINKS, Feature.FILE_CHANNEL).build();

        private WindowsHolder() {
        }
    }

    private static final class OsxHolder {
        private static final Configuration OS_X = Configuration.unix().toBuilder().setNameDisplayNormalization(PathNormalization.NFC, new PathNormalization[0]).setNameCanonicalNormalization(PathNormalization.NFD, PathNormalization.CASE_FOLD_ASCII).setSupportedFeatures(Feature.LINKS, Feature.SYMBOLIC_LINKS, Feature.FILE_CHANNEL).build();

        private OsxHolder() {
        }
    }

    private static final class UnixHolder {
        private static final Configuration UNIX = Configuration.builder(PathType.unix()).setRoots("/", new String[0]).setWorkingDirectory("/work").setAttributeViews("basic", new String[0]).setSupportedFeatures(Feature.LINKS, Feature.SYMBOLIC_LINKS, Feature.SECURE_DIRECTORY_STREAM, Feature.FILE_CHANNEL).build();

        private UnixHolder() {
        }
    }
}

