/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.jimfs.File;
import com.google.common.jimfs.FileLookup;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class AttributeProvider {
    public abstract String name();

    public ImmutableSet<String> inherits() {
        return ImmutableSet.of();
    }

    public abstract Class<? extends FileAttributeView> viewType();

    public abstract FileAttributeView view(FileLookup var1, ImmutableMap<String, FileAttributeView> var2);

    public ImmutableMap<String, ?> defaultValues(Map<String, ?> userDefaults) {
        return ImmutableMap.of();
    }

    public abstract ImmutableSet<String> fixedAttributes();

    public boolean supports(String attribute) {
        return this.fixedAttributes().contains((Object)attribute);
    }

    public ImmutableSet<String> attributes(File file) {
        return this.fixedAttributes();
    }

    @Nullable
    public abstract Object get(File var1, String var2);

    public abstract void set(File var1, String var2, String var3, Object var4, boolean var5);

    @Nullable
    public Class<? extends BasicFileAttributes> attributesType() {
        return null;
    }

    public BasicFileAttributes readAttributes(File file) {
        throw new UnsupportedOperationException();
    }

    protected static IllegalArgumentException unsettable(String view, String attribute) {
        String string = String.valueOf(String.valueOf(view));
        String string2 = String.valueOf(String.valueOf(attribute));
        throw new IllegalArgumentException(new StringBuilder(24 + string.length() + string2.length()).append("cannot set attribute '").append(string).append(":").append(string2).append("'").toString());
    }

    protected static void checkNotCreate(String view, String attribute, boolean create) {
        if (create) {
            String string = String.valueOf(String.valueOf(view));
            String string2 = String.valueOf(String.valueOf(attribute));
            throw new UnsupportedOperationException(new StringBuilder(45 + string.length() + string2.length()).append("cannot set attribute '").append(string).append(":").append(string2).append("' during file creation").toString());
        }
    }

    protected static <T> T checkType(String view, String attribute, Object value, Class<T> type) {
        Preconditions.checkNotNull((Object)value);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw AttributeProvider.invalidType(view, attribute, value, type);
    }

    protected static IllegalArgumentException invalidType(String view, String attribute, Object value, Class<?> ... expectedTypes) {
        Object object;
        if (expectedTypes.length == 1) {
            object = expectedTypes[0];
        } else {
            String string = String.valueOf(Arrays.toString(expectedTypes));
            object = string.length() != 0 ? "one of ".concat(string) : new String("one of ");
        }
        Class<?> expected = object;
        String string = String.valueOf(String.valueOf(value.getClass()));
        String string2 = String.valueOf(String.valueOf(view));
        String string3 = String.valueOf(String.valueOf(attribute));
        String string4 = String.valueOf(String.valueOf(expected));
        throw new IllegalArgumentException(new StringBuilder(42 + string.length() + string2.length() + string3.length() + string4.length()).append("invalid type ").append(string).append(" for attribute '").append(string2).append(":").append(string3).append("': expected ").append(string4).toString());
    }
}

