/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapNavigationTester<K, V>
extends AbstractMapTester<K, V> {
    private NavigableMap<K, V> navigableMap;
    private List<Map.Entry<K, V>> entries;
    private Map.Entry<K, V> a;
    private Map.Entry<K, V> b;
    private Map.Entry<K, V> c;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.navigableMap = (NavigableMap)this.getMap();
        this.entries = Helpers.copyToList(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getSampleElements(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getCollectionSize().getNumElements()));
        Collections.sort(this.entries, Helpers.entryComparator(this.navigableMap.comparator()));
        if (this.entries.size() >= 1) {
            this.a = this.entries.get(0);
            if (this.entries.size() >= 3) {
                this.b = this.entries.get(1);
                this.c = this.entries.get(2);
            }
        }
    }

    private void resetWithHole() {
        Map.Entry[] entries = new Map.Entry[]{this.a, this.c};
        super.resetMap(entries);
        this.navigableMap = (NavigableMap)this.getMap();
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapFirst() {
        MapNavigationTester.assertNull(this.navigableMap.firstEntry());
        try {
            this.navigableMap.firstKey();
            MapNavigationTester.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapPollFirst() {
        MapNavigationTester.assertNull(this.navigableMap.pollFirstEntry());
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapNearby() {
        MapNavigationTester.assertNull(this.navigableMap.lowerEntry(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertNull(this.navigableMap.lowerKey(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertNull(this.navigableMap.floorEntry(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertNull(this.navigableMap.floorKey(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertNull(this.navigableMap.ceilingEntry(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertNull(this.navigableMap.ceilingKey(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertNull(this.navigableMap.higherEntry(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertNull(this.navigableMap.higherKey(((Map.Entry)this.samples.e0).getKey()));
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapLast() {
        MapNavigationTester.assertNull(this.navigableMap.lastEntry());
        try {
            MapNavigationTester.assertNull(this.navigableMap.lastKey());
            MapNavigationTester.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapPollLast() {
        MapNavigationTester.assertNull(this.navigableMap.pollLastEntry());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapFirst() {
        MapNavigationTester.assertEquals(this.a, this.navigableMap.firstEntry());
        MapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.firstKey());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapPollFirst() {
        MapNavigationTester.assertEquals(this.a, this.navigableMap.pollFirstEntry());
        MapNavigationTester.assertTrue((boolean)this.navigableMap.isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapNearby() {
        MapNavigationTester.assertNull(this.navigableMap.lowerEntry(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertNull(this.navigableMap.lowerKey(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertEquals(this.a, this.navigableMap.floorEntry(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.floorKey(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertEquals(this.a, this.navigableMap.ceilingEntry(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.ceilingKey(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertNull(this.navigableMap.higherEntry(((Map.Entry)this.samples.e0).getKey()));
        MapNavigationTester.assertNull(this.navigableMap.higherKey(((Map.Entry)this.samples.e0).getKey()));
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapLast() {
        MapNavigationTester.assertEquals(this.a, this.navigableMap.lastEntry());
        MapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.lastKey());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapPollLast() {
        MapNavigationTester.assertEquals(this.a, this.navigableMap.pollLastEntry());
        MapNavigationTester.assertTrue((boolean)this.navigableMap.isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testFirst() {
        MapNavigationTester.assertEquals(this.a, this.navigableMap.firstEntry());
        MapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.firstKey());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPollFirst() {
        MapNavigationTester.assertEquals(this.a, this.navigableMap.pollFirstEntry());
        MapNavigationTester.assertEquals(this.entries.subList(1, this.entries.size()), Helpers.copyToList(this.navigableMap.entrySet()));
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    public void testPollFirstUnsupported() {
        try {
            this.navigableMap.pollFirstEntry();
            MapNavigationTester.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testLower() {
        this.resetWithHole();
        MapNavigationTester.assertEquals(null, this.navigableMap.lowerEntry(this.a.getKey()));
        MapNavigationTester.assertEquals(null, this.navigableMap.lowerKey(this.a.getKey()));
        MapNavigationTester.assertEquals(this.a, this.navigableMap.lowerEntry(this.b.getKey()));
        MapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.lowerKey(this.b.getKey()));
        MapNavigationTester.assertEquals(this.a, this.navigableMap.lowerEntry(this.c.getKey()));
        MapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.lowerKey(this.c.getKey()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testFloor() {
        this.resetWithHole();
        MapNavigationTester.assertEquals(this.a, this.navigableMap.floorEntry(this.a.getKey()));
        MapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.floorKey(this.a.getKey()));
        MapNavigationTester.assertEquals(this.a, this.navigableMap.floorEntry(this.b.getKey()));
        MapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.floorKey(this.b.getKey()));
        MapNavigationTester.assertEquals(this.c, this.navigableMap.floorEntry(this.c.getKey()));
        MapNavigationTester.assertEquals(this.c.getKey(), this.navigableMap.floorKey(this.c.getKey()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testCeiling() {
        this.resetWithHole();
        MapNavigationTester.assertEquals(this.a, this.navigableMap.ceilingEntry(this.a.getKey()));
        MapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.ceilingKey(this.a.getKey()));
        MapNavigationTester.assertEquals(this.c, this.navigableMap.ceilingEntry(this.b.getKey()));
        MapNavigationTester.assertEquals(this.c.getKey(), this.navigableMap.ceilingKey(this.b.getKey()));
        MapNavigationTester.assertEquals(this.c, this.navigableMap.ceilingEntry(this.c.getKey()));
        MapNavigationTester.assertEquals(this.c.getKey(), this.navigableMap.ceilingKey(this.c.getKey()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testHigher() {
        this.resetWithHole();
        MapNavigationTester.assertEquals(this.c, this.navigableMap.higherEntry(this.a.getKey()));
        MapNavigationTester.assertEquals(this.c.getKey(), this.navigableMap.higherKey(this.a.getKey()));
        MapNavigationTester.assertEquals(this.c, this.navigableMap.higherEntry(this.b.getKey()));
        MapNavigationTester.assertEquals(this.c.getKey(), this.navigableMap.higherKey(this.b.getKey()));
        MapNavigationTester.assertEquals(null, this.navigableMap.higherEntry(this.c.getKey()));
        MapNavigationTester.assertEquals(null, this.navigableMap.higherKey(this.c.getKey()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testLast() {
        MapNavigationTester.assertEquals(this.c, this.navigableMap.lastEntry());
        MapNavigationTester.assertEquals(this.c.getKey(), this.navigableMap.lastKey());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPollLast() {
        MapNavigationTester.assertEquals(this.c, this.navigableMap.pollLastEntry());
        MapNavigationTester.assertEquals(this.entries.subList(0, this.entries.size() - 1), Helpers.copyToList(this.navigableMap.entrySet()));
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPollLastUnsupported() {
        try {
            this.navigableMap.pollLastEntry();
            MapNavigationTester.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testDescendingNavigation() {
        ArrayList descending = new ArrayList();
        for (Map.Entry entry : this.navigableMap.descendingMap().entrySet()) {
            descending.add(entry);
        }
        Collections.reverse(descending);
        MapNavigationTester.assertEquals(this.entries, descending);
    }
}

