/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestMapEntrySetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.TestUnhashableCollectionGenerator;
import com.google.common.collect.testing.UnhashableObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@GwtCompatible
public class MapGenerators {
    private static String toStringOrNull(Object o) {
        return o == null ? null : o.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableMapValueListGenerator
    implements TestListGenerator<String> {
        @Override
        public SampleElements<String> samples() {
            return new SampleElements.Strings();
        }

        @Override
        public List<String> create(Object ... elements) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < elements.length; ++i) {
                builder.put((Object)i, (Object)MapGenerators.toStringOrNull(elements[i]));
            }
            return builder.build().values().asList();
        }

        public String[] createArray(int length) {
            return new String[length];
        }

        @Override
        public Iterable<String> order(List<String> insertionOrder) {
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableMapEntrySetGenerator
    extends TestMapEntrySetGenerator<String, String> {
        public ImmutableMapEntrySetGenerator() {
            super(new SampleElements.Strings(), new SampleElements.Strings());
        }

        @Override
        public Set<Map.Entry<String, String>> createFromEntries(Map.Entry<String, String>[] entries) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, String> entry : entries) {
                Preconditions.checkNotNull(entry);
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return builder.build().entrySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableMapUnhashableValuesGenerator
    extends TestUnhashableCollectionGenerator<Collection<UnhashableObject>> {
        @Override
        public Collection<UnhashableObject> create(UnhashableObject[] elements) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int key = 1;
            for (UnhashableObject value : elements) {
                builder.put((Object)key++, (Object)value);
            }
            return builder.build().values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableMapValuesGenerator
    implements TestCollectionGenerator<String> {
        @Override
        public SampleElements<String> samples() {
            return new SampleElements.Strings();
        }

        @Override
        public Collection<String> create(Object ... elements) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Object key : elements) {
                builder.put(key, (Object)String.valueOf(key));
            }
            return builder.build().values();
        }

        public String[] createArray(int length) {
            return new String[length];
        }

        @Override
        public List<String> order(List<String> insertionOrder) {
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableMapKeySetGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String key : elements) {
                builder.put((Object)key, (Object)4);
            }
            return builder.build().keySet();
        }
    }
}

