/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.NavigableSetTestSuiteBuilder;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.testers.MapNavigationTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigableMapTestSuiteBuilder<K, V>
extends MapTestSuiteBuilder<K, V> {
    public static <K, V> NavigableMapTestSuiteBuilder<K, V> using(TestMapGenerator<K, V> generator) {
        NavigableMapTestSuiteBuilder<K, V> result = new NavigableMapTestSuiteBuilder<K, V>();
        result.usingGenerator(generator);
        return result;
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        List<Class<? extends AbstractTester>> testers = Helpers.copyToList(super.getTesters());
        testers.add(MapNavigationTester.class);
        return testers;
    }

    @Override
    List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>>> parentBuilder) {
        List<TestSuite> derivedSuites = super.createDerivedSuites(parentBuilder);
        if (!parentBuilder.getFeatures().contains(NoRecurse.DESCENDING)) {
            derivedSuites.add(this.createDescendingSuite(parentBuilder));
        }
        if (!parentBuilder.getFeatures().contains(NoRecurse.SUBMAP)) {
            derivedSuites.add(this.createSubmapSuite(parentBuilder, Bound.NO_BOUND, Bound.EXCLUSIVE));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, Bound.NO_BOUND, Bound.INCLUSIVE));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, Bound.EXCLUSIVE, Bound.NO_BOUND));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, Bound.EXCLUSIVE, Bound.EXCLUSIVE));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, Bound.EXCLUSIVE, Bound.INCLUSIVE));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, Bound.INCLUSIVE, Bound.NO_BOUND));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, Bound.INCLUSIVE, Bound.EXCLUSIVE));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, Bound.INCLUSIVE, Bound.INCLUSIVE));
        }
        return derivedSuites;
    }

    @Override
    protected SetTestSuiteBuilder<K> createDerivedKeySetSuite(TestSetGenerator<K> keySetGenerator) {
        return NavigableSetTestSuiteBuilder.using(keySetGenerator);
    }

    private TestSuite createSubmapSuite(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>>> parentBuilder, final Bound from, final Bound to) {
        final TestMapGenerator delegate = (TestMapGenerator)parentBuilder.getSubjectGenerator().getInnerGenerator();
        ArrayList features = new ArrayList();
        features.add(NoRecurse.SUBMAP);
        features.addAll(parentBuilder.getFeatures());
        NavigableMap emptyMap = (NavigableMap)delegate.create(new Object[0]);
        final Comparator entryComparator = Helpers.entryComparator(emptyMap.comparator());
        SampleElements samples = delegate.samples();
        List<Map.Entry> samplesList = Arrays.asList((Map.Entry)samples.e0, (Map.Entry)samples.e1, (Map.Entry)samples.e2, (Map.Entry)samples.e3, (Map.Entry)samples.e4);
        Collections.sort(samplesList, entryComparator);
        final Object firstInclusive = samplesList.get(0).getKey();
        final Object lastInclusive = samplesList.get(samplesList.size() - 1).getKey();
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using(new ForwardingTestMapGenerator<K, V>(delegate){

            @Override
            public Map<K, V> create(Object ... entries) {
                List extremeValues = NavigableMapTestSuiteBuilder.this.getExtremeValues();
                List<Object> normalValues = Arrays.asList(entries);
                Collections.sort(extremeValues, entryComparator);
                Object firstExclusive = ((Map.Entry)extremeValues.get(1)).getKey();
                Object lastExclusive = ((Map.Entry)extremeValues.get(2)).getKey();
                if (from == Bound.NO_BOUND) {
                    extremeValues.remove(0);
                    extremeValues.remove(0);
                }
                if (to == Bound.NO_BOUND) {
                    extremeValues.remove(extremeValues.size() - 1);
                    extremeValues.remove(extremeValues.size() - 1);
                }
                ArrayList<Object> allEntries = new ArrayList<Object>();
                allEntries.addAll(extremeValues);
                allEntries.addAll(normalValues);
                NavigableMap map = (NavigableMap)delegate.create(allEntries.toArray(new Map.Entry[allEntries.size()]));
                if (from == Bound.NO_BOUND && to == Bound.EXCLUSIVE) {
                    return map.headMap(lastExclusive);
                }
                if (from == Bound.NO_BOUND && to == Bound.INCLUSIVE) {
                    return map.headMap(lastInclusive, true);
                }
                if (from == Bound.EXCLUSIVE && to == Bound.NO_BOUND) {
                    return map.tailMap(firstExclusive, false);
                }
                if (from == Bound.EXCLUSIVE && to == Bound.EXCLUSIVE) {
                    return map.subMap(firstExclusive, false, lastExclusive, false);
                }
                if (from == Bound.EXCLUSIVE && to == Bound.INCLUSIVE) {
                    return map.subMap(firstExclusive, false, lastInclusive, true);
                }
                if (from == Bound.INCLUSIVE && to == Bound.NO_BOUND) {
                    return map.tailMap(firstInclusive);
                }
                if (from == Bound.INCLUSIVE && to == Bound.EXCLUSIVE) {
                    return map.subMap(firstInclusive, lastExclusive);
                }
                if (from == Bound.INCLUSIVE && to == Bound.INCLUSIVE) {
                    return map.subMap(firstInclusive, true, lastInclusive, true);
                }
                throw new IllegalArgumentException();
            }
        }).named(parentBuilder.getName() + " subMap " + (Object)((Object)from) + "-" + (Object)((Object)to))).withFeatures(features)).suppressing(parentBuilder.getSuppressedTests())).createTestSuite();
    }

    private List<Map.Entry<String, String>> getExtremeValues() {
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        result.add(Helpers.mapEntry("!! a", "below view"));
        result.add(Helpers.mapEntry("!! b", "below view"));
        result.add(Helpers.mapEntry("~~ y", "above view"));
        result.add(Helpers.mapEntry("~~ z", "above view"));
        return result;
    }

    private TestSuite createDescendingSuite(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>>> parentBuilder) {
        final TestMapGenerator delegate = (TestMapGenerator)parentBuilder.getSubjectGenerator().getInnerGenerator();
        ArrayList features = new ArrayList();
        features.add(NoRecurse.DESCENDING);
        features.addAll(parentBuilder.getFeatures());
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using(new ForwardingTestMapGenerator<K, V>(delegate){

            @Override
            public Map<K, V> create(Object ... entries) {
                NavigableMap map = (NavigableMap)delegate.create(entries);
                return map.descendingMap();
            }
        }).named(parentBuilder.getName() + " descending")).withFeatures(features)).suppressing(parentBuilder.getSuppressedTests())).createTestSuite();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ForwardingTestMapGenerator<K, V>
    implements TestMapGenerator<K, V> {
        private TestMapGenerator<K, V> delegate;

        ForwardingTestMapGenerator(TestMapGenerator<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterable<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
            return this.delegate.order(insertionOrder);
        }

        @Override
        public K[] createKeyArray(int length) {
            return this.delegate.createKeyArray(length);
        }

        @Override
        public V[] createValueArray(int length) {
            return this.delegate.createValueArray(length);
        }

        @Override
        public SampleElements<Map.Entry<K, V>> samples() {
            return this.delegate.samples();
        }

        @Override
        public Map<K, V> create(Object ... elements) {
            return (Map)this.delegate.create(elements);
        }

        public Map.Entry<K, V>[] createArray(int length) {
            return (Map.Entry[])this.delegate.createArray(length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Bound {
        INCLUSIVE,
        EXCLUSIVE,
        NO_BOUND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NoRecurse implements Feature<Void>
    {
        SUBMAP,
        DESCENDING;


        @Override
        public Set<Feature<? super Void>> getImpliedFeatures() {
            return Collections.emptySet();
        }
    }
}

