/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.tools.JavaFileObject;

public class ErrorProneInMemoryFileManager
extends JavacFileManager {
    private final FileSystem fileSystem = Jimfs.newFileSystem((Configuration)Configuration.unix());
    private final Optional<Class<?>> clazz;

    public ErrorProneInMemoryFileManager() {
        this(Optional.absent());
    }

    public ErrorProneInMemoryFileManager(Class<?> clazz) {
        this(Optional.of(clazz));
    }

    private ErrorProneInMemoryFileManager(Optional<Class<?>> clazz) {
        super(new Context(), false, StandardCharsets.UTF_8);
        this.clazz = clazz;
    }

    public List<JavaFileObject> forResources(Class<?> clazz, String ... fileNames) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String fileName : fileNames) {
            result.add((Object)this.forResource(clazz, fileName));
        }
        return result.build();
    }

    public JavaFileObject forResource(Class<?> clazz, String fileName) {
        Path path = this.fileSystem.getPath("/", clazz.getPackage().getName().replace('.', '/'), fileName);
        try (InputStream is = this.findResource(clazz, fileName);){
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.copy(is, path, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return (JavaFileObject)Iterables.getOnlyElement(this.getJavaFileObjects(path));
    }

    private InputStream findResource(Class<?> clazz, String name) {
        InputStream is = clazz.getResourceAsStream(name);
        if (is != null) {
            return is;
        }
        is = clazz.getResourceAsStream("testdata/" + name);
        if (is != null) {
            return is;
        }
        throw new AssertionError((Object)("could not find resource: " + name));
    }

    public JavaFileObject forResource(String fileName) {
        Preconditions.checkState((boolean)this.clazz.isPresent(), (Object)"clazz must be set if you want to add a source from a resource file");
        return this.forResource((Class)this.clazz.get(), fileName);
    }

    private Path resolvePath(String fileName) {
        if (!fileName.startsWith("/")) {
            fileName = "/" + fileName;
        }
        return this.fileSystem.getPath(fileName, new String[0]);
    }

    public JavaFileObject forSourceLines(String fileName, String ... lines) {
        Path path = this.resolvePath(fileName);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, Joiner.on((char)'\n').join((Object[])lines).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return (JavaFileObject)Iterables.getOnlyElement(this.getJavaFileObjects(path));
    }

    public boolean exists(String fileName) {
        return Files.exists(this.resolvePath(fileName), new LinkOption[0]);
    }

    public FileSystem fileSystem() {
        return this.fileSystem;
    }
}

