/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.junit.Assert;

public class DiagnosticTestHelper {
    private final String checkName;
    private final Map<String, Predicate<? super String>> expectedErrorMsgs = new HashMap<String, Predicate<? super String>>();
    public final ClearableDiagnosticCollector<JavaFileObject> collector = new ClearableDiagnosticCollector();
    private static final String BUG_MARKER_COMMENT_INLINE = "// BUG: Diagnostic contains:";
    private static final String BUG_MARKER_COMMENT_LOOKUP = "// BUG: Diagnostic matches:";
    private final Set<String> usedLookupKeys = new HashSet<String>();

    public DiagnosticTestHelper() {
        this(null);
    }

    public DiagnosticTestHelper(String checkName) {
        this.checkName = checkName;
    }

    public static Matcher<Diagnostic<? extends JavaFileObject>> suggestsRemovalOfLine(URI fileURI, int line) {
        return Matchers.allOf(DiagnosticTestHelper.diagnosticOnLine(fileURI, line), DiagnosticTestHelper.diagnosticMessage((Matcher<String>)Matchers.containsString((String)"remove this line")));
    }

    public List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
        return this.collector.getDiagnostics();
    }

    public void clearDiagnostics() {
        this.collector.clear();
    }

    public String describe() {
        StringBuilder stringBuilder = new StringBuilder().append("Diagnostics:\n");
        for (Diagnostic<? extends JavaFileObject> diagnostic : this.getDiagnostics()) {
            stringBuilder.append("  [").append(diagnostic.getLineNumber()).append(":").append(diagnostic.getColumnNumber()).append("]\t");
            stringBuilder.append(diagnostic.getMessage(Locale.getDefault()).replaceAll("\n", "\\\\n"));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static Matcher<Diagnostic<? extends JavaFileObject>> diagnosticLineAndColumn(final long line, final long column) {
        return new TypeSafeDiagnosingMatcher<Diagnostic<? extends JavaFileObject>>(){

            protected boolean matchesSafely(Diagnostic<? extends JavaFileObject> item, Description mismatchDescription) {
                if (item.getLineNumber() != line) {
                    mismatchDescription.appendText("diagnostic not on line ").appendValue((Object)item.getLineNumber());
                    return false;
                }
                if (item.getColumnNumber() != column) {
                    mismatchDescription.appendText("diagnostic not on column ").appendValue((Object)item.getColumnNumber());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("a diagnostic on line:column ").appendValue((Object)line).appendText(":").appendValue((Object)column);
            }
        };
    }

    public static Matcher<Diagnostic<? extends JavaFileObject>> diagnosticOnLine(final URI fileURI, final long line) {
        return new TypeSafeDiagnosingMatcher<Diagnostic<? extends JavaFileObject>>(){

            public boolean matchesSafely(Diagnostic<? extends JavaFileObject> item, Description mismatchDescription) {
                if (item.getSource() == null) {
                    mismatchDescription.appendText("diagnostic not attached to a file: ").appendValue((Object)item.getMessage(Locale.ENGLISH));
                    return false;
                }
                if (!item.getSource().toUri().equals(fileURI)) {
                    mismatchDescription.appendText("diagnostic not in file ").appendValue((Object)fileURI);
                    return false;
                }
                if (item.getLineNumber() != line) {
                    mismatchDescription.appendText("diagnostic not on line ").appendValue((Object)item.getLineNumber());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("a diagnostic on line ").appendValue((Object)line);
            }
        };
    }

    public static Matcher<Diagnostic<? extends JavaFileObject>> diagnosticOnLine(final URI fileURI, final long line, final Predicate<? super String> matcher) {
        return new TypeSafeDiagnosingMatcher<Diagnostic<? extends JavaFileObject>>(){

            public boolean matchesSafely(Diagnostic<? extends JavaFileObject> item, Description mismatchDescription) {
                if (item.getSource() == null) {
                    mismatchDescription.appendText("diagnostic not attached to a file: ").appendValue((Object)item.getMessage(Locale.ENGLISH));
                    return false;
                }
                if (!item.getSource().toUri().equals(fileURI)) {
                    mismatchDescription.appendText("diagnostic not in file ").appendValue((Object)fileURI);
                    return false;
                }
                if (item.getLineNumber() != line) {
                    mismatchDescription.appendText("diagnostic not on line ").appendValue((Object)item.getLineNumber());
                    return false;
                }
                if (!matcher.apply((Object)item.getMessage(Locale.getDefault()))) {
                    mismatchDescription.appendText("diagnostic does not match ").appendValue((Object)matcher);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("a diagnostic on line ").appendValue((Object)line).appendText(" that matches \n").appendValue((Object)matcher).appendText("\n");
            }
        };
    }

    public static Matcher<Diagnostic<? extends JavaFileObject>> diagnosticMessage(final Matcher<String> matcher) {
        return new TypeSafeDiagnosingMatcher<Diagnostic<? extends JavaFileObject>>(){

            public boolean matchesSafely(Diagnostic<? extends JavaFileObject> item, Description mismatchDescription) {
                if (!matcher.matches((Object)item.getMessage(Locale.getDefault()))) {
                    mismatchDescription.appendText("diagnostic message does not match ").appendDescriptionOf((SelfDescribing)matcher);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("a diagnostic with message ").appendDescriptionOf((SelfDescribing)matcher);
            }
        };
    }

    public void expectErrorMessage(String key, Predicate<? super String> matcher) {
        this.expectedErrorMsgs.put(key, matcher);
    }

    public void assertHasDiagnosticOnAllMatchingLines(JavaFileObject source, LookForCheckNameInDiagnostic lookForCheckNameInDiagnostic) throws IOException {
        String line;
        List<Diagnostic<? extends JavaFileObject>> diagnostics = this.getDiagnostics();
        LineNumberReader reader = new LineNumberReader(CharSource.wrap((CharSequence)source.getCharContent(false)).openStream());
        while ((line = reader.readLine()) != null) {
            int lineNumber;
            ArrayList<Predicate<? super String>> predicates = null;
            if (line.contains(BUG_MARKER_COMMENT_INLINE)) {
                List<String> patterns = DiagnosticTestHelper.extractPatterns(line, reader, BUG_MARKER_COMMENT_INLINE);
                predicates = new ArrayList<Predicate<? super String>>(patterns.size());
                for (String string : patterns) {
                    predicates.add(new SimpleStringContains(string));
                }
            } else if (line.contains(BUG_MARKER_COMMENT_LOOKUP)) {
                int markerLineNumber = reader.getLineNumber();
                List<String> lookupKeys = DiagnosticTestHelper.extractPatterns(line, reader, BUG_MARKER_COMMENT_LOOKUP);
                predicates = new ArrayList(lookupKeys.size());
                Iterator iterator = lookupKeys.iterator();
                while (iterator.hasNext()) {
                    String lookupKey = (String)iterator.next();
                    Assert.assertTrue((String)("No expected error message with key [" + lookupKey + "] as expected from line [" + markerLineNumber + "] with diagnostic [" + line.trim() + "]"), (boolean)this.expectedErrorMsgs.containsKey(lookupKey));
                    predicates.add(this.expectedErrorMsgs.get(lookupKey));
                    this.usedLookupKeys.add(lookupKey);
                }
            }
            if (predicates != null) {
                lineNumber = reader.getLineNumber();
                for (Predicate predicate : predicates) {
                    Matcher patternMatcher = Matchers.hasItem(DiagnosticTestHelper.diagnosticOnLine(source.toUri(), lineNumber, (Predicate<? super String>)predicate));
                    Assert.assertTrue((String)("Did not see an error on line " + lineNumber + " matching " + predicate + ". " + DiagnosticTestHelper.allErrors(diagnostics)), (boolean)patternMatcher.matches(diagnostics));
                }
                if (this.checkName == null || lookForCheckNameInDiagnostic != LookForCheckNameInDiagnostic.YES) continue;
                Matcher checkNameMatcher = Matchers.hasItem(DiagnosticTestHelper.diagnosticOnLine(source.toUri(), lineNumber, new SimpleStringContains("[" + this.checkName + "]")));
                Assert.assertTrue((String)("Did not see an error on line " + lineNumber + " containing [" + this.checkName + "]. " + DiagnosticTestHelper.allErrors(diagnostics)), (boolean)checkNameMatcher.matches(diagnostics));
                continue;
            }
            lineNumber = reader.getLineNumber();
            Matcher matcher = Matchers.hasItem(DiagnosticTestHelper.diagnosticOnLine(source.toUri(), lineNumber));
            if (!matcher.matches(diagnostics)) continue;
            Assert.fail((String)("Saw unexpected error on line " + lineNumber + ". " + DiagnosticTestHelper.allErrors(diagnostics)));
        }
        reader.close();
    }

    private static String allErrors(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        if (diagnostics.isEmpty()) {
            return "There were no errors.";
        }
        return "All errors:\n" + diagnostics.stream().map(Object::toString).collect(Collectors.joining("\n\n"));
    }

    public Set<String> getUnusedLookupKeys() {
        return Sets.difference(this.expectedErrorMsgs.keySet(), this.usedLookupKeys);
    }

    private static List<String> extractPatterns(String line, BufferedReader reader, String matchString) throws IOException {
        int bugMarkerIndex = line.indexOf(matchString);
        if (bugMarkerIndex < 0) {
            throw new IllegalArgumentException("Line must contain bug marker prefix");
        }
        ArrayList<String> result = new ArrayList<String>();
        String restOfLine = line.substring(bugMarkerIndex + matchString.length()).trim();
        result.add(restOfLine);
        line = reader.readLine().trim();
        while (line.startsWith("//")) {
            restOfLine = line.substring(2).trim();
            result.add(restOfLine);
            line = reader.readLine().trim();
        }
        return result;
    }

    private static class ClearableDiagnosticCollector<S>
    implements DiagnosticListener<S> {
        private final List<Diagnostic<? extends S>> diagnostics = new ArrayList<Diagnostic<? extends S>>();

        private ClearableDiagnosticCollector() {
        }

        @Override
        public void report(Diagnostic<? extends S> diagnostic) {
            this.diagnostics.add(diagnostic);
        }

        public List<Diagnostic<? extends S>> getDiagnostics() {
            return ImmutableList.copyOf(this.diagnostics);
        }

        public void clear() {
            this.diagnostics.clear();
        }
    }

    private static class SimpleStringContains
    implements Predicate<String> {
        private final String pattern;

        SimpleStringContains(String pattern) {
            this.pattern = pattern;
        }

        public boolean apply(String input) {
            return input.contains(this.pattern);
        }

        public String toString() {
            return this.pattern;
        }
    }

    static enum LookForCheckNameInDiagnostic {
        YES,
        NO;

    }
}

