/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.errorprone.BaseErrorProneJavaCompiler;
import com.google.errorprone.BugPattern;
import com.google.errorprone.DiagnosticTestHelper;
import com.google.errorprone.ErrorProneInMemoryFileManager;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.main.Main;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.junit.Assert;

public class CompilationTestHelper {
    private static final ImmutableList<String> DEFAULT_ARGS = ImmutableList.of((Object)"-encoding", (Object)"UTF-8", (Object)"-XDdev", (Object)"-parameters", (Object)"-XDcompilePolicy=simple");
    private final DiagnosticTestHelper diagnosticHelper;
    private final BaseErrorProneJavaCompiler compiler;
    private final ByteArrayOutputStream outputStream;
    private final ErrorProneInMemoryFileManager fileManager;
    private final List<JavaFileObject> sources = new ArrayList<JavaFileObject>();
    private List<String> args = ImmutableList.of();
    private boolean expectNoDiagnostics = false;
    private Optional<Main.Result> expectedResult = Optional.absent();
    private boolean checkWellFormed = true;
    private DiagnosticTestHelper.LookForCheckNameInDiagnostic lookForCheckNameInDiagnostic = DiagnosticTestHelper.LookForCheckNameInDiagnostic.YES;

    private CompilationTestHelper(ScannerSupplier scannerSupplier, String checkName, Class<?> clazz) {
        this.fileManager = new ErrorProneInMemoryFileManager(clazz);
        try {
            this.fileManager.setLocation(StandardLocation.SOURCE_PATH, Collections.emptyList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.diagnosticHelper = new DiagnosticTestHelper(checkName);
        this.outputStream = new ByteArrayOutputStream();
        this.compiler = new BaseErrorProneJavaCompiler((JavaCompiler)JavacTool.create(), scannerSupplier);
    }

    public static CompilationTestHelper newInstance(ScannerSupplier scannerSupplier, Class<?> clazz) {
        return new CompilationTestHelper(scannerSupplier, null, clazz);
    }

    public static CompilationTestHelper newInstance(Class<? extends BugChecker> checker, Class<?> clazz) {
        ScannerSupplier scannerSupplier = ScannerSupplier.fromBugCheckerClasses((Class[])new Class[]{checker});
        String checkName = checker.getAnnotation(BugPattern.class).name();
        return new CompilationTestHelper(scannerSupplier, checkName, clazz);
    }

    static List<String> disableImplicitProcessing(List<String> args) {
        if (args.indexOf("-processor") != -1 || args.indexOf("-processorpath") != -1) {
            return args;
        }
        return ImmutableList.builder().addAll(args).add((Object)"-proc:none").build();
    }

    private static List<String> buildArguments(List<String> extraArgs) {
        return ImmutableList.builder().addAll(DEFAULT_ARGS).addAll(CompilationTestHelper.disableImplicitProcessing(extraArgs)).build();
    }

    public CompilationTestHelper addSourceLines(String path, String ... lines) {
        this.sources.add(this.fileManager.forSourceLines(path, lines));
        return this;
    }

    public CompilationTestHelper addSourceFile(String path) {
        this.sources.add(this.fileManager.forResource(path));
        return this;
    }

    public CompilationTestHelper setArgs(List<String> args) {
        this.args = args;
        return this;
    }

    public CompilationTestHelper expectNoDiagnostics() {
        this.expectNoDiagnostics = true;
        return this;
    }

    public CompilationTestHelper ignoreJavacErrors() {
        this.checkWellFormed = false;
        return this;
    }

    public CompilationTestHelper matchAllDiagnostics() {
        this.lookForCheckNameInDiagnostic = DiagnosticTestHelper.LookForCheckNameInDiagnostic.NO;
        return this;
    }

    public CompilationTestHelper expectResult(Main.Result result) {
        this.expectedResult = Optional.of((Object)((Object)result));
        return this;
    }

    public CompilationTestHelper expectErrorMessage(String key, Predicate<? super String> matcher) {
        this.diagnosticHelper.expectErrorMessage(key, matcher);
        return this;
    }

    public void doTest() {
        Preconditions.checkState((!this.sources.isEmpty() ? 1 : 0) != 0, (Object)"No source files to compile");
        List<String> allArgs = CompilationTestHelper.buildArguments(this.args);
        Main.Result result = this.compile(this.sources, allArgs.toArray(new String[allArgs.size()]));
        for (Diagnostic<? extends JavaFileObject> diagnostic : this.diagnosticHelper.getDiagnostics()) {
            if (!diagnostic.getCode().contains("error.prone.crash")) continue;
            Assert.fail((String)diagnostic.getMessage(Locale.ENGLISH));
        }
        if (this.expectNoDiagnostics) {
            List<Diagnostic<? extends JavaFileObject>> diagnostics = this.diagnosticHelper.getDiagnostics();
            Truth.assertWithMessage((String)String.format("Expected no diagnostics produced, but found %d: %s", diagnostics.size(), diagnostics)).that(Integer.valueOf(diagnostics.size())).isEqualTo((Object)0);
            Truth.assertWithMessage((String)String.format("Expected compilation result to be " + this.expectedResult.or((Object)Main.Result.OK) + ", but was %s. No diagnostics were emitted. OutputStream from Compiler follows.\n\n%s", new Object[]{result, this.outputStream.toString()})).that((Comparable)((Object)result)).isEqualTo(this.expectedResult.or((Object)Main.Result.OK));
        } else {
            for (JavaFileObject source : this.sources) {
                try {
                    this.diagnosticHelper.assertHasDiagnosticOnAllMatchingLines(source, this.lookForCheckNameInDiagnostic);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            Assert.assertTrue((String)("Unused error keys: " + this.diagnosticHelper.getUnusedLookupKeys()), (boolean)this.diagnosticHelper.getUnusedLookupKeys().isEmpty());
        }
        if (this.expectedResult.isPresent()) {
            Truth.assertWithMessage((String)String.format("Expected compilation result %s, but was %s\n%s\n%s", new Object[]{this.expectedResult.get(), result, Joiner.on((char)'\n').join(this.diagnosticHelper.getDiagnostics()), this.outputStream.toString()})).that((Comparable)((Object)result)).isEqualTo(this.expectedResult.get());
        }
    }

    private Main.Result compile(Iterable<JavaFileObject> sources, String[] args) {
        if (this.checkWellFormed) {
            this.checkWellFormed(sources, args);
        }
        CompilationTestHelper.createAndInstallTempFolderForOutput(this.fileManager);
        return this.compiler.getTask((Writer)new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)this.outputStream, StandardCharsets.UTF_8)), true), (JavaFileManager)this.fileManager, this.diagnosticHelper.collector, (Iterable)ImmutableList.copyOf((Object[])args), (Iterable)ImmutableList.of(), sources).call() != false ? Main.Result.OK : Main.Result.ERROR;
    }

    private static void createAndInstallTempFolderForOutput(ErrorProneInMemoryFileManager fileManager) {
        Path tempDirectory;
        try {
            tempDirectory = Files.createTempDirectory(fileManager.fileSystem().getRootDirectories().iterator().next(), "", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Arrays.stream(StandardLocation.values()).filter(StandardLocation::isOutputLocation).forEach(outputLocation -> {
            try {
                fileManager.setLocationFromPaths((JavaFileManager.Location)outputLocation, (Collection<? extends Path>)ImmutableList.of((Object)tempDirectory));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private void checkWellFormed(Iterable<JavaFileObject> sources, String[] args) {
        CompilationTestHelper.createAndInstallTempFolderForOutput(this.fileManager);
        JavacTool compiler = JavacTool.create();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String[] remainingArgs = null;
        try {
            remainingArgs = ErrorProneOptions.processArgs((String[])args).getRemainingArgs();
        }
        catch (InvalidCommandLineOptionException e) {
            Assert.fail((String)("Exception during argument processing: " + (Object)((Object)e)));
        }
        JavaCompiler.CompilationTask task = compiler.getTask((Writer)new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8)), true), (JavaFileManager)this.fileManager, null, CompilationTestHelper.buildArguments(Arrays.asList(remainingArgs)), null, sources);
        boolean result = task.call();
        Truth.assertWithMessage((String)String.format("Test program failed to compile with non Error Prone error: %s", ((Object)outputStream).toString())).that(Boolean.valueOf(result)).isTrue();
    }
}

