/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xbean.converters.impl;

import com.googlecode.xbean.conversion.Conversion;
import com.googlecode.xbean.conversion.SourceDetails;
import com.googlecode.xbean.conversion.TargetDetails;
import com.googlecode.xbean.conversion.impl.AutoAnnotationConversion;
import com.googlecode.xbean.conversion.impl.CustomPropertyConversion;
import com.googlecode.xbean.conversion.impl.DefaultConversion;
import com.googlecode.xbean.conversion.impl.ListPropertyConversion;
import com.googlecode.xbean.conversion.impl.SetPropertyConversion;
import com.googlecode.xbean.converters.BeanConverter;
import com.googlecode.xbean.converters.PropertyConverter;
import com.googlecode.xbean.exceptions.CannotConvertException;
import com.googlecode.xbean.util.XBeanUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationBeanConverter
implements BeanConverter {
    private List<Conversion> conversionList = new ArrayList<Conversion>();

    public AnnotationBeanConverter() {
        this.conversionList.add(new ListPropertyConversion(this));
        this.conversionList.add(new SetPropertyConversion(this));
        this.conversionList.add(new AutoAnnotationConversion(this));
        this.conversionList.add(new DefaultConversion());
    }

    public void setConversionList(List<Conversion> pConversionList) {
        this.conversionList.addAll(0, pConversionList);
    }

    @Override
    public <S, D> List<D> convertToList(List<S> pSourceList, Class<D> pDestination) throws Exception {
        return new ListPropertyConversion(this).convertToList(pSourceList, pDestination);
    }

    @Override
    public <S, D> Set<D> convertToSet(Set<S> pSourceSet, Class<D> pDestination) throws Exception {
        return new SetPropertyConversion(this).convertToSet(pSourceSet, pDestination);
    }

    @Override
    public <S, D> D convert(Class<D> pTargetClass, S ... pSourceInstances) throws CannotConvertException {
        D targetInstance;
        try {
            targetInstance = pTargetClass.newInstance();
        }
        catch (Exception e) {
            throw new CannotConvertException(e);
        }
        return this.convertByInstance(targetInstance, pSourceInstances);
    }

    @Override
    public <S, D> D convertByInstance(D targetInstance, S ... pSourceInstances) throws CannotConvertException {
        return this.convertByInstanceConverter(targetInstance, XBeanUtils.emptySet, pSourceInstances);
    }

    @Override
    public <S, D, P extends PropertyConverter<?, ?>> D convertByInstanceConverter(D pTargetInstance, Set<P> pConverterInstanceSet, S ... pSourceInstances) throws CannotConvertException {
        if (pTargetInstance == null || pSourceInstances == null) {
            throw new NullPointerException("One or all parameters(targetInstance,pSourceInstances) are null");
        }
        Class<?> targetClass = pTargetInstance.getClass();
        if (XBeanUtils.isPrimitive(targetClass)) {
            S s = pSourceInstances[0];
            if (s.getClass().equals(targetClass)) {
                return (D)s;
            }
            throw new CannotConvertException("Cannot convert instance of type " + s.getClass() + " to " + targetClass);
        }
        ArrayList<Conversion> tempConversionList = new ArrayList<Conversion>(this.conversionList);
        if (!pConverterInstanceSet.isEmpty()) {
            Map<String, P> convertorsMap = XBeanUtils.createPropertyConverterMap(pConverterInstanceSet);
            tempConversionList.add(0, new CustomPropertyConversion<P>(convertorsMap));
        }
        try {
            Map<String, String> fieldsMap = XBeanUtils.createTargetFieldsMap(targetClass);
            for (S pSourceInstance : pSourceInstances) {
                Field[] sourceFields;
                for (Field sourceField : sourceFields = pSourceInstance.getClass().getDeclaredFields()) {
                    Conversion conversion;
                    if (!fieldsMap.containsKey(sourceField.getName())) continue;
                    Field targetField = targetClass.getDeclaredField(fieldsMap.get(sourceField.getName()));
                    targetField.setAccessible(true);
                    sourceField.setAccessible(true);
                    SourceDetails sourceDetails = new SourceDetails(pSourceInstance, sourceField);
                    TargetDetails targetDetails = new TargetDetails(pTargetInstance, targetField);
                    Iterator i$ = tempConversionList.iterator();
                    while (i$.hasNext() && !(conversion = (Conversion)i$.next()).convert(sourceDetails, targetDetails)) {
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CannotConvertException(e);
        }
        return pTargetInstance;
    }
}

