/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xbean.conversion.impl;

import com.googlecode.xbean.conversion.Conversion;
import com.googlecode.xbean.conversion.SourceDetails;
import com.googlecode.xbean.conversion.TargetDetails;
import com.googlecode.xbean.converters.BeanConverter;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetPropertyConversion
implements Conversion {
    private BeanConverter converter;

    public SetPropertyConversion(BeanConverter converter) {
        this.converter = converter;
    }

    @Override
    public boolean convert(SourceDetails sourceDetails, TargetDetails targetDetails) throws Exception {
        Field targetField = targetDetails.getField();
        Object sourceFieldObj = sourceDetails.getFieldObject();
        if (sourceFieldObj instanceof Set) {
            ParameterizedType dparamType = (ParameterizedType)targetField.getGenericType();
            Set targetPropertyObject = this.convertToSet((Set)sourceFieldObj, (Class)dparamType.getActualTypeArguments()[0]);
            targetField.set(targetDetails.getInstance(), targetPropertyObject);
            return true;
        }
        return false;
    }

    public <S, D> Set<D> convertToSet(Set<S> pSourceSet, Class<D> pDestination) throws Exception {
        if (pDestination == null) {
            throw new NullPointerException("Parameter pDestination is null");
        }
        HashSet<D> destSet = new HashSet<D>(pSourceSet.size());
        if (pSourceSet != null) {
            for (S source : pSourceSet) {
                destSet.add(this.converter.convert(pDestination, source));
            }
        }
        return destSet;
    }
}

