/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xbean.conversion.impl;

import com.googlecode.xbean.conversion.Conversion;
import com.googlecode.xbean.conversion.SourceDetails;
import com.googlecode.xbean.conversion.TargetDetails;
import com.googlecode.xbean.converters.BeanConverter;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPropertyConversion
implements Conversion {
    private BeanConverter converter;

    public ListPropertyConversion(BeanConverter converter) {
        this.converter = converter;
    }

    @Override
    public boolean convert(SourceDetails sourceDetails, TargetDetails targetDetails) throws Exception {
        Field targetField = targetDetails.getField();
        Object sourceFieldObj = sourceDetails.getFieldObject();
        if (sourceFieldObj instanceof List) {
            ParameterizedType dparamType = (ParameterizedType)targetField.getGenericType();
            List targetPropertyObject = this.convertToList((List)sourceFieldObj, (Class)dparamType.getActualTypeArguments()[0]);
            targetField.set(targetDetails.getInstance(), targetPropertyObject);
            return true;
        }
        return false;
    }

    public <S, D> List<D> convertToList(List<S> pSourceList, Class<D> pDestination) throws Exception {
        if (pDestination == null) {
            throw new NullPointerException("Parameter pDestination is null");
        }
        ArrayList<D> destList = new ArrayList<D>(pSourceList.size());
        if (pSourceList != null) {
            for (S source : pSourceList) {
                destList.add(this.converter.convert(pDestination, source));
            }
        }
        return destList;
    }
}

