/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xbean.conversion.impl;

import com.googlecode.xbean.annotations.Convertible;
import com.googlecode.xbean.conversion.Conversion;
import com.googlecode.xbean.conversion.SourceDetails;
import com.googlecode.xbean.conversion.TargetDetails;
import com.googlecode.xbean.converters.PropertyConverter;
import com.googlecode.xbean.converters.impl.DefaultConvertor;
import java.lang.reflect.Field;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomPropertyConversion<P extends PropertyConverter<?, ?>>
implements Conversion {
    private Map<String, P> convertorsMap;

    public CustomPropertyConversion(Map<String, P> convertorsMap2) {
        this.convertorsMap = convertorsMap2;
    }

    @Override
    public boolean convert(SourceDetails sourceDetails, TargetDetails targetDetails) throws Exception {
        Field targetField = targetDetails.getField();
        String customPropertyConverter = this.getConverterClassName(targetField);
        if (customPropertyConverter != null) {
            PropertyConverter pConverter = (PropertyConverter)this.convertorsMap.get(customPropertyConverter);
            Object targetPropertyObject = pConverter.convert(sourceDetails.getFieldObject());
            targetField.set(targetDetails.getInstance(), targetPropertyObject);
            return true;
        }
        return false;
    }

    private String getConverterClassName(Field pTargetField) {
        Convertible targetAnnotation = pTargetField.getAnnotation(Convertible.class);
        if (targetAnnotation != null && targetAnnotation.convertor() != null && targetAnnotation.convertor() != DefaultConvertor.class) {
            return targetAnnotation.convertor().getName();
        }
        return null;
    }
}

