/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xbean.conversion.impl;

import com.googlecode.xbean.annotations.Convertible;
import com.googlecode.xbean.conversion.Conversion;
import com.googlecode.xbean.conversion.SourceDetails;
import com.googlecode.xbean.conversion.TargetDetails;
import com.googlecode.xbean.converters.BeanConverter;
import java.lang.reflect.Field;

public class AutoAnnotationConversion
implements Conversion {
    private BeanConverter converter;

    public AutoAnnotationConversion(BeanConverter converter) {
        this.converter = converter;
    }

    public boolean convert(SourceDetails sourceDetails, TargetDetails targetDetails) throws Exception {
        Field targetField = targetDetails.getField();
        if (this.isAutoAvailable(targetField)) {
            Object targetFieldObject = this.converter.convert(targetField.getType(), sourceDetails.getFieldObject());
            targetField.set(targetDetails.getInstance(), targetFieldObject);
            return true;
        }
        return false;
    }

    private boolean isAutoAvailable(Field pTargetField) {
        Convertible targetAnnotation = pTargetField.getAnnotation(Convertible.class);
        return targetAnnotation != null && targetAnnotation.auto();
    }
}

