/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.protocol.binary.OperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiGetOperationImpl
extends OperationImpl
implements GetOperation {
    private static final int CMD_GETQ = 9;
    private final Map<Integer, String> keys = new HashMap<Integer, String>();
    private final Map<Integer, byte[]> bkeys = new HashMap<Integer, byte[]>();
    private final Map<String, Integer> rkeys = new HashMap<String, Integer>();
    private final int terminalOpaque = MultiGetOperationImpl.generateOpaque();

    public MultiGetOperationImpl(Collection<String> k, OperationCallback cb) {
        super(-1, -1, cb);
        for (String s : new HashSet<String>(k)) {
            this.addKey(s);
        }
    }

    protected int addKey(String k) {
        Integer rv = this.rkeys.get(k);
        if (rv == null) {
            rv = MultiGetOperationImpl.generateOpaque();
            this.keys.put(rv, k);
            this.bkeys.put(rv, KeyUtil.getKeyBytes(k));
            this.rkeys.put(k, rv);
        }
        return rv;
    }

    @Override
    public void initialize() {
        int size = (1 + this.keys.size()) * 24;
        for (byte[] b : this.bkeys.values()) {
            size += b.length;
        }
        ByteBuffer bb = ByteBuffer.allocate(size);
        for (Map.Entry<Integer, byte[]> me : this.bkeys.entrySet()) {
            byte[] keyBytes = me.getValue();
            bb.put((byte)-128);
            bb.put((byte)9);
            bb.putShort((short)keyBytes.length);
            bb.put((byte)0);
            bb.put((byte)0);
            bb.putShort((short)0);
            bb.putInt(keyBytes.length);
            bb.putInt(me.getKey());
            bb.putLong(0L);
            bb.put(keyBytes);
        }
        bb.put((byte)-128);
        bb.put((byte)10);
        bb.putShort((short)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.putShort((short)0);
        bb.putInt(0);
        bb.putInt(this.terminalOpaque);
        bb.putLong(0L);
        bb.flip();
        this.setBuffer(bb);
    }

    @Override
    protected void finishedPayload(byte[] pl) throws IOException {
        if (this.responseOpaque == this.terminalOpaque) {
            this.getCallback().receivedStatus(STATUS_OK);
            this.transitionState(OperationState.COMPLETE);
        } else if (this.errorCode != 0) {
            this.getLogger().warn("Error on key %s:  %s (%d)", this.keys.get(this.responseOpaque), new String(pl), this.errorCode);
        } else {
            int flags = MultiGetOperationImpl.decodeInt(pl, 0);
            byte[] data = new byte[pl.length - 4];
            System.arraycopy(pl, 4, data, 0, pl.length - 4);
            GetOperation.Callback cb = (GetOperation.Callback)this.getCallback();
            cb.gotData(this.keys.get(this.responseOpaque), flags, data);
        }
        this.resetInput();
    }

    @Override
    protected boolean opaqueIsValid() {
        return this.responseOpaque == this.terminalOpaque || this.keys.containsKey(this.responseOpaque);
    }

    @Override
    public Collection<String> getKeys() {
        return this.keys.values();
    }
}

