/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.ops.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckedOperationTimeoutException
extends TimeoutException {
    private final Collection<Operation> operations;

    public CheckedOperationTimeoutException(String message, Operation op) {
        this(message, Collections.singleton(op));
    }

    public CheckedOperationTimeoutException(String message, Collection<Operation> ops) {
        super(CheckedOperationTimeoutException.createMessage(message, ops));
        this.operations = ops;
    }

    private static String createMessage(String message, Collection<Operation> ops) {
        StringBuilder rv = new StringBuilder(message);
        rv.append(" - failing node");
        rv.append(ops.size() == 1 ? ": " : "s: ");
        boolean first = true;
        for (Operation op : ops) {
            if (first) {
                first = false;
            } else {
                rv.append(", ");
            }
            MemcachedNode node = op == null ? null : op.getHandlingNode();
            rv.append(node == null ? "<unknown>" : node.getSocketAddress());
        }
        return rv.toString();
    }

    public Collection<Operation> getOperations() {
        return this.operations;
    }
}

