/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.util.Clock;
import com.google.api.client.util.Preconditions;
import com.google.auth.Credentials;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAccountJwtAccessCredentials
extends Credentials {
    static final String JWT_ACCESS_PREFIX = "Bearer ";
    private final String clientId;
    private final String clientEmail;
    private final PrivateKey privateKey;
    private final String privateKeyId;
    private final URI defaultAudience;
    Clock clock = Clock.SYSTEM;

    public ServiceAccountJwtAccessCredentials(String clientId, String clientEmail, PrivateKey privateKey, String privateKeyId) {
        this(clientId, clientEmail, privateKey, privateKeyId, null);
    }

    public ServiceAccountJwtAccessCredentials(String clientId, String clientEmail, PrivateKey privateKey, String privateKeyId, URI defaultAudience) {
        this.clientId = clientId;
        this.clientEmail = (String)Preconditions.checkNotNull((Object)clientEmail);
        this.privateKey = (PrivateKey)Preconditions.checkNotNull((Object)privateKey);
        this.privateKeyId = privateKeyId;
        this.defaultAudience = defaultAudience;
    }

    static ServiceAccountJwtAccessCredentials fromJson(Map<String, Object> json) throws IOException {
        return ServiceAccountJwtAccessCredentials.fromJson(json, null);
    }

    static ServiceAccountJwtAccessCredentials fromJson(Map<String, Object> json, URI defaultAudience) throws IOException {
        String clientId = (String)json.get("client_id");
        String clientEmail = (String)json.get("client_email");
        String privateKeyPkcs8 = (String)json.get("private_key");
        String privateKeyId = (String)json.get("private_key_id");
        if (clientId == null || clientEmail == null || privateKeyPkcs8 == null || privateKeyId == null) {
            throw new IOException("Error reading service account credential from JSON, expecting  'client_id', 'client_email', 'private_key' and 'private_key_id'.");
        }
        return ServiceAccountJwtAccessCredentials.fromPkcs8(clientId, clientEmail, privateKeyPkcs8, privateKeyId, defaultAudience);
    }

    public static ServiceAccountJwtAccessCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId) throws IOException {
        return ServiceAccountJwtAccessCredentials.fromPkcs8(clientId, clientEmail, privateKeyPkcs8, privateKeyId, null);
    }

    public static ServiceAccountJwtAccessCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, URI defaultAudience) throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8(privateKeyPkcs8);
        return new ServiceAccountJwtAccessCredentials(clientId, clientEmail, privateKey, privateKeyId, defaultAudience);
    }

    public String getAuthenticationType() {
        return "JWTAccess";
    }

    public boolean hasRequestMetadata() {
        return true;
    }

    public boolean hasRequestMetadataOnly() {
        return true;
    }

    public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
        if (uri == null) {
            if (this.defaultAudience != null) {
                uri = this.defaultAudience;
            } else {
                throw new IOException("JwtAccess requires Audience uri to be passed in or the defaultAudience to be specified");
            }
        }
        String assertion = this.getJwtAccess(uri);
        String string = String.valueOf(JWT_ACCESS_PREFIX);
        String string2 = String.valueOf(assertion);
        String authorizationHeader = string2.length() != 0 ? string.concat(string2) : new String(string);
        List<String> newAuthorizationHeaders = Collections.singletonList(authorizationHeader);
        Map<String, List<String>> newRequestMetadata = Collections.singletonMap("Authorization", newAuthorizationHeaders);
        return newRequestMetadata;
    }

    public void refresh() {
    }

    private String getJwtAccess(URI uri) throws IOException {
        JsonWebSignature.Header header = new JsonWebSignature.Header();
        header.setAlgorithm("RS256");
        header.setType("JWT");
        header.setKeyId(this.privateKeyId);
        JsonWebToken.Payload payload = new JsonWebToken.Payload();
        long currentTime = this.clock.currentTimeMillis();
        payload.setIssuer(this.clientEmail);
        payload.setSubject(this.clientEmail);
        payload.setAudience((Object)uri.toString());
        payload.setIssuedAtTimeSeconds(Long.valueOf(currentTime / 1000L));
        payload.setExpirationTimeSeconds(Long.valueOf(currentTime / 1000L + 3600L));
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        String assertion = null;
        try {
            assertion = JsonWebSignature.signUsingRsaSha256((PrivateKey)this.privateKey, (JsonFactory)jsonFactory, (JsonWebSignature.Header)header, (JsonWebToken.Payload)payload);
        }
        catch (GeneralSecurityException e) {
            throw OAuth2Utils.exceptionWithCause(new IOException("Error signing service account JWT access header with private key."), e);
        }
        return assertion;
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final String getClientEmail() {
        return this.clientEmail;
    }

    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public final String getPrivateKeyId() {
        return this.privateKeyId;
    }
}

