/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import org.apache.geronimo.mail.util.SessionUtil;

public class MimeMultipart
extends Multipart {
    private static final String MIME_IGNORE_MISSING_BOUNDARY = "mail.mime.multipart.ignoremissingendboundary";
    protected DataSource ds;
    protected boolean parsed = true;
    private transient ContentType type;
    private boolean complete = true;
    private String preamble = null;
    private static byte[] dash = new byte[]{45, 45};
    private static byte[] crlf = new byte[]{13, 10};
    private static int part;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String subtype) {
        this.type = new ContentType("multipart", subtype, null);
        this.type.setParameter("boundary", MimeMultipart.getBoundary());
        this.contentType = this.type.toString();
    }

    public MimeMultipart(DataSource dataSource) throws MessagingException {
        this.ds = dataSource;
        if (dataSource instanceof MultipartDataSource) {
            super.setMultipartDataSource((MultipartDataSource)dataSource);
            this.parsed = true;
        } else {
            this.contentType = this.ds.getContentType();
            this.type = new ContentType(this.contentType);
            this.parsed = false;
        }
    }

    public void setSubType(String subtype) throws MessagingException {
        this.type.setSubType(subtype);
        this.contentType = this.type.toString();
    }

    @Override
    public int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    @Override
    public synchronized BodyPart getBodyPart(int part) throws MessagingException {
        this.parse();
        return super.getBodyPart(part);
    }

    public BodyPart getBodyPart(String cid) throws MessagingException {
        this.parse();
        for (int i = 0; i < this.parts.size(); ++i) {
            MimeBodyPart bodyPart = (MimeBodyPart)this.parts.get(i);
            if (!cid.equals(bodyPart.getContentID())) continue;
            return bodyPart;
        }
        return null;
    }

    protected void updateHeaders() throws MessagingException {
        this.parse();
        for (int i = 0; i < this.parts.size(); ++i) {
            MimeBodyPart bodyPart = (MimeBodyPart)this.parts.get(i);
            bodyPart.updateHeaders();
        }
    }

    @Override
    public void writeTo(OutputStream out) throws IOException, MessagingException {
        this.parse();
        String boundary = this.type.getParameter("boundary");
        byte[] bytes = boundary.getBytes();
        if (this.preamble != null) {
            byte[] preambleBytes = this.preamble.getBytes();
            out.write(preambleBytes);
            out.write(crlf);
        }
        for (int i = 0; i < this.parts.size(); ++i) {
            BodyPart bodyPart = (BodyPart)this.parts.get(i);
            out.write(dash);
            out.write(bytes);
            out.write(crlf);
            bodyPart.writeTo(out);
            out.write(crlf);
        }
        out.write(dash);
        out.write(bytes);
        out.write(dash);
        out.write(crlf);
        out.flush();
    }

    protected void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        try {
            MimeBodyPartInputStream partStream;
            ContentType cType = new ContentType(this.contentType);
            BufferedInputStream is = new BufferedInputStream(this.ds.getInputStream());
            BufferedInputStream pushbackInStream = null;
            String boundaryString = cType.getParameter("boundary");
            byte[] boundary = null;
            if (boundaryString == null) {
                pushbackInStream = new BufferedInputStream(is, 1200);
                boundary = this.readTillFirstBoundary(pushbackInStream);
            } else {
                boundary = ("--" + boundaryString).getBytes();
                pushbackInStream = new BufferedInputStream(is, boundary.length + 1000);
                this.readTillFirstBoundary(pushbackInStream, boundary);
            }
            do {
                partStream = new MimeBodyPartInputStream(pushbackInStream, boundary);
                this.addBodyPart(new MimeBodyPart(partStream));
                if (partStream.boundaryFound) continue;
                if (!SessionUtil.getBooleanProperty(MIME_IGNORE_MISSING_BOUNDARY, true)) {
                    throw new MessagingException("Missing Multi-part end boundary");
                }
                this.complete = false;
            } while (!partStream.finalBoundaryFound);
        }
        catch (Exception e) {
            throw new MessagingException(e.toString(), e);
        }
        this.parsed = true;
    }

    private byte[] readTillFirstBoundary(BufferedInputStream pushbackInStream) throws MessagingException {
        ByteArrayOutputStream preambleStream = new ByteArrayOutputStream();
        try {
            while (true) {
                byte[] line;
                if ((line = this.readLine(pushbackInStream)) == null) {
                    throw new MessagingException("Unexpected End of Stream while searching for first Mime Boundary");
                }
                if (line.length > 2 && line[0] == 45 && line[1] == 45) {
                    byte[] preambleBytes = preambleStream.toByteArray();
                    if (preambleBytes.length > 0) {
                        this.preamble = new String(preambleBytes);
                    }
                    return this.stripLinearWhiteSpace(line);
                }
                preambleStream.write(line);
                preambleStream.write(13);
                preambleStream.write(10);
            }
        }
        catch (IOException ioe) {
            throw new MessagingException(ioe.toString(), ioe);
        }
    }

    private byte[] stripLinearWhiteSpace(byte[] line) {
        int index = line.length - 1;
        if (line[index] != 32 && line[index] != 9) {
            return line;
        }
        while (index > 0 && (line[index] == 32 || line[index] == 9)) {
            --index;
        }
        byte[] newLine = new byte[index + 1];
        System.arraycopy(line, 0, newLine, 0, index + 1);
        return newLine;
    }

    private void readTillFirstBoundary(BufferedInputStream pushbackInStream, byte[] boundary) throws MessagingException {
        ByteArrayOutputStream preambleStream = new ByteArrayOutputStream();
        try {
            while (true) {
                byte[] line;
                if ((line = this.readLine(pushbackInStream)) == null) {
                    throw new MessagingException("Unexpected End of Stream while searching for first Mime Boundary");
                }
                if (this.compareBoundary(line, boundary)) {
                    byte[] preambleBytes = preambleStream.toByteArray();
                    if (preambleBytes.length > 0) {
                        this.preamble = new String(preambleBytes);
                    }
                    return;
                }
                preambleStream.write(line);
                preambleStream.write(13);
                preambleStream.write(10);
            }
        }
        catch (IOException ioe) {
            throw new MessagingException(ioe.toString(), ioe);
        }
    }

    private boolean compareBoundary(byte[] line, byte[] boundary) {
        int i;
        if (line.length < boundary.length) {
            return false;
        }
        if (line.length == boundary.length) {
            return Arrays.equals(line, boundary);
        }
        for (i = 0; i < boundary.length; ++i) {
            if (line[i] == boundary[i]) continue;
            return false;
        }
        for (i = boundary.length; i < line.length; ++i) {
            if (line[i] == 32 || line[i] == 9) continue;
            return false;
        }
        return true;
    }

    private byte[] readLine(BufferedInputStream in) throws IOException {
        ByteArrayOutputStream line = new ByteArrayOutputStream();
        while (in.available() > 0) {
            int value = in.read();
            if (value == -1) {
                if (line.size() != 0) break;
                return null;
            }
            if (value == 13) {
                in.mark(10);
                value = in.read();
                if (value == 10) break;
                in.reset();
                break;
            }
            if (value == 10) break;
            line.write((byte)value);
        }
        return line.toByteArray();
    }

    protected InternetHeaders createInternetHeaders(InputStream in) throws MessagingException {
        return new InternetHeaders(in);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders headers, byte[] data) throws MessagingException {
        return new MimeBodyPart(headers, data);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream in) throws MessagingException {
        return new MimeBodyPart(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getBoundary() {
        Class<MimeMultipart> clazz = MimeMultipart.class;
        synchronized (MimeMultipart.class) {
            int i = part++;
            // ** MonitorExit[var0] (shouldn't be in output)
            StringBuffer buf = new StringBuffer(64);
            buf.append("----=_Part_").append(i).append('_').append(new Object().hashCode()).append('.').append(System.currentTimeMillis());
            return buf.toString();
        }
    }

    public boolean isComplete() throws MessagingException {
        this.parse();
        return this.complete;
    }

    public String getPreamble() throws MessagingException {
        this.parse();
        return this.preamble;
    }

    public void setPreamble(String preamble) throws MessagingException {
        this.preamble = preamble;
    }

    private class MimeBodyPartInputStream
    extends InputStream {
        BufferedInputStream inStream;
        public boolean boundaryFound = false;
        byte[] boundary;
        public boolean finalBoundaryFound = false;

        public MimeBodyPartInputStream(BufferedInputStream inStream, byte[] boundary) {
            this.inStream = inStream;
            this.boundary = boundary;
        }

        @Override
        public int read() throws IOException {
            int boundaryIndex;
            if (this.boundaryFound) {
                return -1;
            }
            int firstChar = this.inStream.read();
            if (firstChar == -1) {
                this.boundaryFound = true;
                this.finalBoundaryFound = true;
                return -1;
            }
            if (firstChar != 13 && firstChar != 10) {
                return firstChar;
            }
            this.inStream.mark(this.boundary.length + 1000);
            int value = firstChar;
            if (value == 13 && (value = this.inStream.read()) != 10) {
                this.inStream.reset();
                return 13;
            }
            value = this.inStream.read();
            if ((byte)value != this.boundary[0]) {
                this.inStream.reset();
                return firstChar;
            }
            for (boundaryIndex = 0; boundaryIndex < this.boundary.length && (byte)value == this.boundary[boundaryIndex]; ++boundaryIndex) {
                value = this.inStream.read();
            }
            if (boundaryIndex != this.boundary.length) {
                this.inStream.reset();
                return firstChar;
            }
            if (value == 45) {
                value = this.inStream.read();
                if (value != 45) {
                    this.inStream.reset();
                    return firstChar;
                }
                value = this.inStream.read();
                while (value == 32 || value == 9) {
                    value = this.inStream.read();
                }
                if (value == -1) {
                    this.finalBoundaryFound = true;
                    this.boundaryFound = true;
                    return -1;
                }
                if (value != 13 && value != 10) {
                    this.inStream.reset();
                    return firstChar;
                }
                if (value == 13 && (value = this.inStream.read()) != 10) {
                    this.inStream.reset();
                    return firstChar;
                }
                this.finalBoundaryFound = true;
            } else {
                while (value == 32 || value == 9) {
                    value = this.inStream.read();
                }
                if (value != 13 && value != 10) {
                    this.inStream.reset();
                    return firstChar;
                }
                if (value == 13 && (value = this.inStream.read()) != 10) {
                    this.inStream.reset();
                    return firstChar;
                }
            }
            this.boundaryFound = true;
            return -1;
        }
    }
}

