/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.client.datastoreservice.intern.DatastoreRpcException;
import com.google.apphosting.datastore.DatastoreV4;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class InternDatastoreRpcService {
    InternDatastoreRpcService() {
    }

    public static <S extends MessageLite> RpcSpec<S> createRpcSpec(String packageName, String methodName, Parser<S> responseParser) {
        return new RpcSpec<S>(packageName, methodName, responseParser);
    }

    public <R extends MessageLite, S extends MessageLite> ResponseFutureWrapper<S> call(RpcSpec<S> rpcSpec, R request) {
        return new ResponseFutureWrapper(rpcSpec.responseParser, ApiProxy.makeAsyncCall(rpcSpec.packageName, rpcSpec.methodName, request.toByteArray()));
    }

    public static class ResponseFutureWrapper<S extends MessageLite> {
        private final Parser<S> responseParser;
        private final Future<byte[]> responseByteArrayFuture;

        public ResponseFutureWrapper(Parser<S> responseParser, Future<byte[]> responseByteArrayFuture) {
            this.responseByteArrayFuture = responseByteArrayFuture;
            this.responseParser = responseParser;
        }

        public S getResponse() throws DatastoreRpcException {
            try {
                return (S)((MessageLite)this.responseParser.parseFrom(this.responseByteArrayFuture.get()));
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                throw new DatastoreRpcException("Unexpected interrupt.", exception);
            }
            catch (InvalidProtocolBufferException exception) {
                throw new DatastoreRpcException("Unexpected deserialization failure.", exception);
            }
            catch (ExecutionException exception) {
                throw ResponseFutureWrapper.translateExecutionException(exception);
            }
        }

        private static DatastoreRpcException translateExecutionException(ExecutionException exception) throws DatastoreRpcException {
            Throwable cause = exception.getCause();
            if (cause instanceof ApiProxy.ApiProxyException) {
                throw ResponseFutureWrapper.translateApiProxyException((ApiProxy.ApiProxyException)cause);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new DatastoreRpcException("Unexpected exception.", cause);
        }

        private static DatastoreRpcException translateApiProxyException(ApiProxy.ApiProxyException apiProxyException) throws DatastoreRpcException {
            Codes.Code errorCode = Codes.Code.INTERNAL;
            String message = apiProxyException.getMessage();
            if (apiProxyException instanceof ApiProxy.ApplicationException) {
                ApiProxy.ApplicationException applicationException = (ApiProxy.ApplicationException)apiProxyException;
                switch (DatastoreV4.Error.ErrorCode.valueOf(applicationException.getApplicationError())) {
                    case NEED_INDEX: 
                    case SAFE_TIME_TOO_OLD: {
                        errorCode = Codes.Code.FAILED_PRECONDITION;
                        break;
                    }
                    case BAD_REQUEST: {
                        errorCode = Codes.Code.INVALID_ARGUMENT;
                        break;
                    }
                    case CONCURRENT_TRANSACTION: {
                        errorCode = Codes.Code.ABORTED;
                        break;
                    }
                    case BIGTABLE_ERROR: 
                    case TIMEOUT: {
                        errorCode = Codes.Code.DEADLINE_EXCEEDED;
                        break;
                    }
                    case PERMISSION_DENIED: {
                        errorCode = Codes.Code.PERMISSION_DENIED;
                        break;
                    }
                    case CAPABILITY_DISABLED: {
                        errorCode = Codes.Code.UNAVAILABLE;
                        break;
                    }
                }
                message = applicationException.getErrorDetail();
            } else if (apiProxyException instanceof ApiProxy.ApiDeadlineExceededException) {
                errorCode = Codes.Code.DEADLINE_EXCEEDED;
            } else if (apiProxyException instanceof ApiProxy.RequestTooLargeException) {
                errorCode = Codes.Code.INVALID_ARGUMENT;
            } else if (apiProxyException instanceof ApiProxy.CapabilityDisabledException) {
                errorCode = Codes.Code.PERMISSION_DENIED;
            } else if (apiProxyException instanceof ApiProxy.OverQuotaException) {
                errorCode = Codes.Code.RESOURCE_EXHAUSTED;
            }
            throw new DatastoreRpcException(errorCode, message, apiProxyException);
        }
    }

    public static class RpcSpec<S extends MessageLite> {
        public final String packageName;
        public final String methodName;
        public final Parser<S> responseParser;

        public RpcSpec(String packageName, String methodName, Parser<S> responseParser) {
            this.packageName = packageName;
            this.methodName = methodName;
            this.responseParser = responseParser;
        }
    }
}

