/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.apphosting.client.datastoreservice.api.DatastoreServiceRpcProto;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;

class EntityTranslator {
    public static final EntityTranslator DEFAULT = new EntityTranslator();

    public DatastoreServiceRpcProto.EntityResult translate(DatastoreV4.EntityResult entityResult, Format outputFormat) {
        return DatastoreServiceRpcProto.EntityResult.newBuilder().setEntity(this.translate(entityResult.getEntity(), outputFormat)).build();
    }

    public EntityV4.Entity translate(EntityV4.Entity entity, Format outputFormat) {
        if (entity.getPropertyCount() == 0) {
            return entity;
        }
        switch (outputFormat) {
            case V1BETA1: {
                if (!entity.getProperty(0).hasValue()) {
                    return entity;
                }
                EntityV4.Entity.Builder builder = entity.toBuilder();
                this.toV1Beta1Format(builder);
                return builder.build();
            }
            case V1BETA2: {
                if (entity.getProperty(0).hasValue()) {
                    return entity;
                }
                EntityV4.Entity.Builder builder = entity.toBuilder();
                this.toV1Beta2Format(builder);
                return builder.build();
            }
        }
        throw new IllegalStateException("Unknown output format: " + (Object)((Object)outputFormat));
    }

    private void toV1Beta2Format(EntityV4.Entity.Builder entity) {
        for (EntityV4.Property.Builder prop : entity.getPropertyBuilderList()) {
            this.toV1Beta2Format(prop);
        }
    }

    private boolean hasEntityWithProperties(EntityV4.ValueOrBuilder value) {
        return value.hasEntityValue() && value.getEntityValueOrBuilder().getPropertyCount() > 0;
    }

    private void toV1Beta2Format(EntityV4.Property.Builder prop) {
        if (prop.getDeprecatedMulti()) {
            EntityV4.Value.Builder value = prop.getValueBuilder();
            value.addAllListValue(prop.getDeprecatedValueList());
            for (int i = 0; i < value.getListValueCount(); ++i) {
                EntityV4.ValueOrBuilder subValue = value.getListValueOrBuilder(i);
                if (!this.hasEntityWithProperties(subValue)) continue;
                this.toV1Beta2Format(value.getListValueBuilder(i).getEntityValueBuilder());
            }
        } else if (prop.getDeprecatedValueCount() > 0) {
            prop.setValue(prop.getDeprecatedValue(0));
            if (this.hasEntityWithProperties(prop.getValueOrBuilder())) {
                this.toV1Beta2Format(prop.getValueBuilder().getEntityValueBuilder());
            }
        }
        prop.clearDeprecatedMulti().clearDeprecatedValue();
    }

    private void toV1Beta1Format(EntityV4.Entity.Builder entity) {
        for (EntityV4.Property.Builder prop : entity.getPropertyBuilderList()) {
            this.toV1Beta1Format(prop);
        }
    }

    private void toV1Beta1Format(EntityV4.Property.Builder prop) {
        if (prop.getValueOrBuilder().getListValueCount() > 0) {
            prop.setDeprecatedMulti(true);
            prop.addAllDeprecatedValue(prop.getValueOrBuilder().getListValueList());
        } else {
            prop.addDeprecatedValue(prop.getValue());
        }
        prop.clearValue();
        for (int i = 0; i < prop.getDeprecatedValueCount(); ++i) {
            EntityV4.ValueOrBuilder value = prop.getDeprecatedValueOrBuilder(i);
            if (!this.hasEntityWithProperties(value)) continue;
            this.toV1Beta1Format(prop.getDeprecatedValueBuilder(i).getEntityValueBuilder());
        }
    }

    static enum Format {
        V1BETA1,
        V1BETA2;

    }
}

