/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.apphosting.client.datastoreservice.intern.AllocateIdsHandler;
import com.google.apphosting.client.datastoreservice.intern.BeginTransactionHandler;
import com.google.apphosting.client.datastoreservice.intern.BlindWriteHandler;
import com.google.apphosting.client.datastoreservice.intern.CommitHandler;
import com.google.apphosting.client.datastoreservice.intern.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.intern.EntityTranslator;
import com.google.apphosting.client.datastoreservice.intern.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.intern.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.intern.LookupHandler;
import com.google.apphosting.client.datastoreservice.intern.RollbackHandler;
import com.google.apphosting.client.datastoreservice.intern.RunQueryHandler;
import com.google.apphosting.client.datastoreservice.intern.ServiceRegistry;

public class DatastoreRpcService {
    final InternDatastoreRpcService internDatastoreRpcService;
    final EntityV4Normalizer entityNormalizer;

    public DatastoreRpcService(String defaultDatasetId) {
        this(new InternDatastoreRpcService(), defaultDatasetId);
    }

    @VisibleForTesting
    DatastoreRpcService(InternDatastoreRpcService internDatastoreRpcService, String defaultDatasetId) {
        this.internDatastoreRpcService = internDatastoreRpcService;
        this.entityNormalizer = new EntityV4Normalizer(defaultDatasetId);
    }

    public void registerService(ServiceRegistry registry) {
        String[] v1beta1 = new String[]{"v1beta1"};
        String[] v1beta2 = new String[]{"v1", "v1beta2"};
        String[] all = new String[]{"v1", "v1beta1", "v1beta2"};
        this.registerHandler(registry, all, "allocateIds", new AllocateIdsHandler(this.entityNormalizer, this.internDatastoreRpcService));
        this.registerHandler(registry, all, "beginTransaction", new BeginTransactionHandler(this.internDatastoreRpcService));
        this.registerHandler(registry, all, "commit", new CommitHandler(this.entityNormalizer, this.internDatastoreRpcService));
        this.registerHandler(registry, all, "rollback", new RollbackHandler(this.internDatastoreRpcService));
        this.registerHandler(registry, v1beta1, "lookup", new LookupHandler(this.entityNormalizer, EntityTranslator.DEFAULT, EntityTranslator.Format.V1BETA1, this.internDatastoreRpcService));
        this.registerHandler(registry, v1beta2, "lookup", new LookupHandler(this.entityNormalizer, EntityTranslator.DEFAULT, EntityTranslator.Format.V1BETA2, this.internDatastoreRpcService));
        this.registerHandler(registry, v1beta1, "runQuery", new RunQueryHandler(this.entityNormalizer, EntityTranslator.DEFAULT, EntityTranslator.Format.V1BETA1, this.internDatastoreRpcService));
        this.registerHandler(registry, v1beta2, "runQuery", new RunQueryHandler(this.entityNormalizer, EntityTranslator.DEFAULT, EntityTranslator.Format.V1BETA2, this.internDatastoreRpcService));
        this.registerHandler(registry, v1beta1, "blindWrite", new BlindWriteHandler(this.entityNormalizer, this.internDatastoreRpcService));
    }

    private <R extends MessageLite, S extends MessageLite> void registerHandler(ServiceRegistry registry, String[] versions, String methodName, DatastoreRpcHandler<R, S> handler) {
        for (String versionName : versions) {
            registry.registerHandler("datastore", versionName, methodName, handler);
        }
    }
}

