/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.api.DatastoreServiceRpcProto;
import com.google.apphosting.client.datastoreservice.intern.DatastoreRpcException;
import com.google.apphosting.client.datastoreservice.intern.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.intern.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.intern.InternDatastoreRpcService;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;
import java.util.List;

class AllocateIdsHandler
extends DatastoreRpcHandler<DatastoreServiceRpcProto.AllocateIdsRequest, DatastoreServiceRpcProto.AllocateIdsResponse> {
    private static final int DEFAULT_MAX_KEYS_PER_BATCH = 500;
    private final int maxKeysPerBatch;
    @VisibleForTesting
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.AllocateIdsResponse> INTERN_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "AllocateIds", DatastoreV4.AllocateIdsResponse.PARSER);
    private final EntityV4Normalizer entityNormalizer;

    public AllocateIdsHandler(EntityV4Normalizer entityNormalizer, InternDatastoreRpcService internDatastoreRpcService) {
        this(entityNormalizer, internDatastoreRpcService, 500);
    }

    AllocateIdsHandler(EntityV4Normalizer entityNormalizer, InternDatastoreRpcService internDatastoreRpcService, int maxKeysPerBatch) {
        super(internDatastoreRpcService);
        this.entityNormalizer = entityNormalizer;
        this.maxKeysPerBatch = maxKeysPerBatch;
    }

    @Override
    public Parser<DatastoreServiceRpcProto.AllocateIdsRequest> getParser() {
        return DatastoreServiceRpcProto.AllocateIdsRequest.PARSER;
    }

    @Override
    public DatastoreServiceRpcProto.AllocateIdsResponse call(DatastoreRpcHandler.CallOptions options, DatastoreServiceRpcProto.AllocateIdsRequest apiReq) throws DatastoreRpcException {
        ArrayList<InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.AllocateIdsResponse>> futures = Lists.newArrayListWithExpectedSize(apiReq.getKeyCount() / this.maxKeysPerBatch + 1);
        for (int i = 0; i < apiReq.getKeyCount(); i += this.maxKeysPerBatch) {
            List<EntityV4.Key> keys = this.entityNormalizer.normalizeKeyList(apiReq.getKeyList().subList(i, Math.min(apiReq.getKeyCount(), i + this.maxKeysPerBatch)));
            DatastoreV4.AllocateIdsRequest allocateIdsRequest = DatastoreV4.AllocateIdsRequest.newBuilder().addAllAllocate(keys).build();
            futures.add(this.internDatastoreRpcService.call(INTERN_RPC_SPEC, allocateIdsRequest));
        }
        DatastoreServiceRpcProto.AllocateIdsResponse.Builder respBuilder = DatastoreServiceRpcProto.AllocateIdsResponse.newBuilder();
        for (InternDatastoreRpcService.ResponseFutureWrapper responseFutureWrapper : futures) {
            respBuilder.addAllKey(((DatastoreV4.AllocateIdsResponse)responseFutureWrapper.getResponse()).getAllocatedList());
        }
        return respBuilder.build();
    }

    @Override
    public DatastoreServiceRpcProto.AllocateIdsResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreServiceRpcProto.AllocateIdsResponse.newBuilder().setHeader(this.makeErrorHeader(errorCode, message)).build();
    }
}

