/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.bridge;

import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessage;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ProtoConverter<P1 extends ProtocolMessage<P1>, P2 extends Message>
extends Converter<P1, P2> {
    private final P1 defaultProto1;
    private final P2 defaultProto2;
    private final ExtensionRegistryLite extensionRegistry;

    private ProtoConverter(P1 defaultProto1, P2 defaultProto2, ExtensionRegistryLite extensionRegistry) {
        this.defaultProto1 = defaultProto1;
        this.defaultProto2 = defaultProto2;
        this.extensionRegistry = extensionRegistry;
    }

    public static <P1 extends ProtocolMessage<P1>, P2 extends Message> ProtoConverter<P1, P2> forProtos(P1 proto1, P2 proto2, ExtensionRegistryLite extensionRegistry) {
        Preconditions.checkNotNull(proto1, "proto1");
        Preconditions.checkNotNull(proto2, "proto2");
        Preconditions.checkNotNull(extensionRegistry, "extensionRegistry");
        MutableMessage emptyProto1 = proto1.clone();
        ((ProtocolMessage)emptyProto1).clear();
        return new ProtoConverter<MutableMessage, P2>(emptyProto1, proto2, extensionRegistry);
    }

    public static <P1 extends ProtocolMessage<P1>, P2 extends Message> ProtoConverter<P1, P2> forProtos(P1 proto1, P2 proto2) {
        return ProtoConverter.forProtos(proto1, proto2, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public P2 doForward(P1 object) {
        Preconditions.checkNotNull(object);
        try {
            return (P2)this.defaultProto2.newBuilderForType().mergeFrom(((ProtocolMessage)object).toByteArray(), this.extensionRegistry).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("The proto1 message could not be parsed with the proto2 type.  Are %s and %s really the same type?", this.defaultProto1.getClass(), this.defaultProto2.getClass()), e);
        }
    }

    @Override
    public P1 doBackward(P2 object) {
        Preconditions.checkNotNull(object);
        MutableMessage p1 = ((ProtocolMessage)this.defaultProto1).clone();
        if (!((ProtocolMessage)p1).mergeFrom(object.toByteArray())) {
            throw new IllegalStateException(String.format("The proto2 message could not be parsed with the proto1 type.  Are %s and %s the really the same type?", this.defaultProto1.getClass(), this.defaultProto2.getClass()));
        }
        return (P1)p1;
    }
}

