/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.escape.SourceCodeEscapers;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.FlagSpec;
import com.google.appengine.repackaged.com.google.common.io.ByteSource;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import com.google.appengine.repackaged.com.google.common.xml.XmlEscapers;
import com.google.appengine.repackaged.com.google.io.base.IORuntimeException;
import com.google.appengine.repackaged.com.google.io.protocol.CategoryInformation;
import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.MessageSet;
import com.google.appengine.repackaged.com.google.io.protocol.MessageVisitor;
import com.google.appengine.repackaged.com.google.io.protocol.MissingFieldVisitor;
import com.google.appengine.repackaged.com.google.io.protocol.Proto2BuilderAdapter;
import com.google.appengine.repackaged.com.google.io.protocol.Proto2ParserAdapter;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import com.google.appengine.repackaged.com.google.protobuf.AbstractMutableMessage;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessage;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.com.google.protobuf.UninitializedMessageException;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;

public abstract class ProtocolMessage<T extends ProtocolMessage<T>>
extends AbstractMutableMessage
implements Serializable,
BeanInfo {
    @FlagSpec(help="Force int64 to be printed as decimal", altName="protocol_printer_format_large_ints_as_decimal")
    @VisibleForTesting
    static final Flag<Boolean> protocolPrinterFormatLargeIntsAsDecimal = Flag.value(false);
    private static final String[] formattedHex = new String[256];
    private static final Logger logger;
    private static final EnumSet<PrintFlag> FLAGS_DEFAULT;
    private static final EnumSet<PrintFlag> FLAGS_WITH_INDEX;

    public String findInitializationError() {
        if (this.isInitialized()) {
            return null;
        }
        MissingFieldVisitor visitor = new MissingFieldVisitor();
        ProtocolType.visit(this, visitor);
        return "missing field: " + visitor.getMissingFieldName();
    }

    @Override
    public abstract boolean isInitialized();

    public abstract int encodingSize();

    public abstract int maxEncodingSize();

    public T clear() {
        return this.internalClear();
    }

    protected T internalClear() {
        throw new UnsupportedOperationException("clear() is not implemented");
    }

    public abstract T newInstance();

    public T freeze() {
        return (T)this;
    }

    public T unfreeze() {
        return (T)this;
    }

    public boolean isFrozen() {
        return false;
    }

    public abstract T mergeFrom(T var1);

    public T copyFrom(T that) {
        if (that == this) {
            return that;
        }
        this.clear();
        return this.mergeFrom(that);
    }

    public T clone() {
        ProtocolMessage copy = this.newInstance();
        copy.mergeFrom((T)this);
        return (T)copy;
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();

    public abstract boolean equals(T var1);

    public abstract boolean equalsIgnoreUninterpreted(T var1);

    public abstract boolean equals(T var1, boolean var2);

    public abstract void outputTo(ProtocolSink var1);

    public final ProtocolSink toProtocolSink() {
        ProtocolSink sink = new ProtocolSink(this.maxEncodingSize());
        this.outputTo(sink);
        return sink;
    }

    public final void outputTo(byte[] buf, int offset) {
        this.outputTo(new ProtocolSink(buf, offset));
    }

    @Override
    public final byte[] toByteArray() {
        return this.toProtocolSink().toArray();
    }

    public final void outputTo(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset();
            ProtocolSink sink = new ProtocolSink(buffer.array(), offset + buffer.position());
            this.outputTo(sink);
            if (sink.position() - offset > buffer.limit()) {
                throw new BufferOverflowException();
            }
            buffer.position(sink.position() - offset);
        } else {
            ProtocolSink sink = this.toProtocolSink();
            buffer.put(sink.array(), 0, sink.position());
        }
    }

    public final ByteBuffer toByteBuffer() {
        ProtocolSink sink = this.toProtocolSink();
        return ByteBuffer.wrap(sink.array(), 0, sink.position()).order(ByteOrder.LITTLE_ENDIAN);
    }

    public final void outputTo(OutputStream stream) {
        try {
            ProtocolSink sink = this.toProtocolSink();
            stream.write(sink.array(), 0, sink.position());
        }
        catch (IOException ioe) {
            throw new IORuntimeException(ioe);
        }
    }

    protected abstract boolean merge(ProtocolSource var1);

    public final boolean mergeFrom(ProtocolSource source) {
        try {
            return this.merge(source);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public final boolean mergeFrom(byte[] buf) {
        return this.mergeFrom(new ProtocolSource(buf));
    }

    @Override
    public final boolean mergeFrom(byte[] buf, int offset, int length) {
        return this.mergeFrom(new ProtocolSource(buf, offset, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean mergeFrom(ByteBuffer buffer) {
        try {
            ProtocolSource source = new ProtocolSource(buffer);
            boolean bl = this.mergeFrom(source);
            return bl;
        }
        catch (BufferUnderflowException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            buffer.position(buffer.limit());
        }
    }

    @Override
    public final boolean mergeFrom(InputStream in) {
        try {
            return this.mergeFrom(ByteStreams.toByteArray(in));
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean mergeFrom(ByteSource supplier) {
        boolean bl;
        InputStream in = supplier.openStream();
        try {
            bl = this.mergeFrom(ByteStreams.toByteArray(in));
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        in.close();
        return bl;
    }

    public final boolean parseFrom(ProtocolSource source) {
        this.clear();
        return this.mergeFrom(source);
    }

    @Override
    public final boolean parseFrom(byte[] buf) {
        this.clear();
        return this.mergeFrom(buf);
    }

    @Override
    public final boolean parseFrom(byte[] buf, int offset, int length) {
        this.clear();
        return this.mergeFrom(buf, offset, length);
    }

    public final boolean parseFrom(ByteBuffer buf) {
        this.clear();
        return this.mergeFrom(buf);
    }

    @Override
    public final boolean parseFrom(InputStream in) {
        this.clear();
        return this.mergeFrom(in);
    }

    public final boolean parseFrom(ByteSource supplier) {
        this.clear();
        return this.mergeFrom(supplier);
    }

    public MessageAppender getMessageAppender() {
        return null;
    }

    @Override
    public String toString() {
        return this.toString("", false);
    }

    public String toString(PrintFlag ... flags) {
        Set<PrintFlag> flagSet = ProtocolMessage.toEnumSet(flags);
        return this.toString("", flagSet);
    }

    public String toString(Set<PrintFlag> flags) {
        return this.toString("", flags);
    }

    public String toString(boolean printIndex) {
        return this.toString("", printIndex);
    }

    public String toString(String prefix, boolean printIndex) {
        return this.toString(prefix, printIndex ? FLAGS_WITH_INDEX : FLAGS_DEFAULT);
    }

    private static Set<PrintFlag> applyLargeIntAsDecimalFlag(Set<PrintFlag> flags) {
        if (protocolPrinterFormatLargeIntsAsDecimal.get().booleanValue() && !flags.contains((Object)PrintFlag.NUMBERS_ALWAYS_DECIMAL)) {
            if (!(flags instanceof EnumSet)) {
                flags = EnumSet.copyOf(flags);
            }
            flags.add(PrintFlag.NUMBERS_ALWAYS_DECIMAL);
        }
        return flags;
    }

    public String toString(String prefix, Set<PrintFlag> flags) {
        flags = ProtocolMessage.applyLargeIntAsDecimalFlag(flags);
        StringBuilder sb = new StringBuilder();
        this.outputText(sb, prefix, flags);
        if (sb.length() > 0 && !flags.contains((Object)PrintFlag.FLATTEN)) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString(int maxChars, PrintFlag ... flags) {
        if (maxChars < 3) {
            return "...";
        }
        Set<PrintFlag> flagSet = ProtocolMessage.toEnumSet(flags);
        flagSet = ProtocolMessage.applyLargeIntAsDecimalFlag(flagSet);
        StringBuilder sb = new StringBuilder();
        BoundedAsciiVisitor visitor = new BoundedAsciiVisitor(sb, "", flagSet, maxChars);
        visitor.visit(this);
        if (!((AbstractVisitor)visitor).canAccept() && sb.length() > 0) {
            boolean endedWithQuote = sb.charAt(sb.length() - 1) == '\"';
            sb.delete(maxChars - 4, sb.length()).append("...");
            if (endedWithQuote) {
                sb.append('\"');
            }
        }
        return sb.toString();
    }

    public String toFlatString(int maxChars) {
        return this.toString(maxChars, PrintFlag.FLATTEN);
    }

    public String toFlatString() {
        return this.toFlatString(false);
    }

    public String toFlatString(boolean printIndex) {
        EnumSet<PrintFlag> flags = EnumSet.of(PrintFlag.FLATTEN);
        if (printIndex) {
            flags.add(PrintFlag.SHOW_ELEMENT_NUMBERS);
        }
        return this.outputText(new StringBuilder(), null, flags).toString();
    }

    private static Set<PrintFlag> toEnumSet(PrintFlag ... flags) {
        EnumSet<PrintFlag> flagSet = EnumSet.noneOf(PrintFlag.class);
        for (PrintFlag flag : flags) {
            flagSet.add(flag);
        }
        return flagSet;
    }

    @Override
    public ProtocolMessage getDefaultInstanceForType() {
        return null;
    }

    @Override
    public final void writeTo(CodedOutputStream output) throws IOException {
        ProtocolSink sink = this.toProtocolSink();
        output.writeRawBytes(sink.array(), 0, sink.position());
    }

    @Override
    public final int getSerializedSize() {
        return this.encodingSize();
    }

    @Override
    public final ByteString toByteString() {
        ByteBuffer byteBuffer = this.toByteBuffer();
        return ByteString.copyFrom(byteBuffer);
    }

    @Override
    public final void writeTo(OutputStream output) throws IOException {
        this.outputTo(output);
    }

    @Override
    public final void writeDelimitedTo(OutputStream output) throws IOException {
        int serializedSize = this.getSerializedSize();
        int varIntSize = CodedOutputStream.computeRawVarint32Size(serializedSize);
        ProtocolSink sink = new ProtocolSink(varIntSize + serializedSize);
        sink.putVarInt(serializedSize);
        this.outputTo(sink);
        output.write(sink.array(), 0, sink.position());
    }

    @Override
    public final Message.Builder newBuilderForType() {
        return new Proto2BuilderAdapter<T>(this.newInstance());
    }

    @Override
    public final Message.Builder toBuilder() {
        ProtocolMessage copy = this.newInstance();
        copy.mergeFrom((T)this);
        return new Proto2BuilderAdapter<T>(copy);
    }

    private StringBuilder outputText(StringBuilder sb, String prefix, Set<PrintFlag> flags) {
        new AsciiVisitor(sb, prefix, flags).visit(this);
        return sb;
    }

    public String toXmlString() {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\"?>\n<toplevel>\n");
        new XmlVisitor(sb, "  ").visit(this);
        return sb.append("\n</toplevel>\n").toString();
    }

    public abstract ProtocolType getProtocolType();

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return null;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        if (this.getClass() != ProtocolMessage.class) {
            return this.getProtocolType().getPropertyDescriptors();
        }
        return null;
    }

    @Override
    public int getDefaultPropertyIndex() {
        return -1;
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return null;
    }

    @Override
    public int getDefaultEventIndex() {
        return -1;
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return null;
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        return null;
    }

    @Override
    public Image getIcon(int iconKind) {
        return null;
    }

    public CategoryInformation<T> messageCategoryInformation() {
        return null;
    }

    public Parser<? extends ProtocolMessage> getParserForType() {
        return new Proto2ParserAdapter<ProtocolMessage>(this.getDefaultInstanceForType());
    }

    @Override
    protected UninitializedMessageException newUninitializedMessageException() {
        return new UninitializedMessageException(this);
    }

    public T newMessageForType() {
        return this.newInstance();
    }

    public T mergeFrom(MutableMessage other) {
        if (other instanceof ProtocolMessage) {
            return (T)this.mergeFrom((T)((ProtocolMessage)other));
        }
        return (T)((ProtocolMessage)super.mergeFrom(other));
    }

    public T copyFrom(MutableMessage other) {
        if (other instanceof ProtocolMessage) {
            return (T)this.copyFrom((T)((ProtocolMessage)other));
        }
        return (T)((ProtocolMessage)super.copyFrom(other));
    }

    @Override
    public boolean mergePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) {
        return this.mergeFrom(input, extensionRegistry);
    }

    @Override
    public boolean mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) {
        try {
            if (!this.isProto1Group()) {
                if (this.mergeFrom(ProtocolSupport.readCodedInputToProtocolSource(input))) {
                    return input.readTag() == 0;
                }
                return false;
            }
            input.mergeToMessage(this);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected FieldAccessorTable internalGetFieldAccessorTable() {
        throw new UnsupportedOperationException("proto2 reflection is not implemented for this class");
    }

    @Override
    public Descriptors.Descriptor getDescriptorForType() {
        return this.internalGetFieldAccessorTable().getDescriptor();
    }

    protected Map<Descriptors.FieldDescriptor, Object> getAllFieldsMutable() {
        TreeMap<Descriptors.FieldDescriptor, Object> result = new TreeMap<Descriptors.FieldDescriptor, Object>();
        Descriptors.Descriptor descriptor = this.getDescriptorForType();
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            if (field.isRepeated()) {
                List value = (List)this.getField(field);
                if (value.isEmpty()) continue;
                result.put(field, value);
                continue;
            }
            if (!this.hasField(field)) continue;
            result.put(field, this.getField(field));
        }
        return result;
    }

    @Override
    public Map<Descriptors.FieldDescriptor, Object> getAllFields() {
        return Collections.unmodifiableMap(this.getAllFieldsMutable());
    }

    @Override
    public boolean hasField(Descriptors.FieldDescriptor field) {
        return this.internalGetFieldAccessorTable().getFieldAccessor(field).has(this);
    }

    @Override
    public Object getField(Descriptors.FieldDescriptor field) {
        return this.internalGetFieldAccessorTable().getFieldAccessor(field).get(this);
    }

    public T setField(Descriptors.FieldDescriptor field, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.assertMutable();
        this.internalGetFieldAccessorTable().getFieldAccessor(field).set(this, value);
        return (T)this;
    }

    public T clearField(Descriptors.FieldDescriptor field) {
        this.assertMutable();
        this.internalGetFieldAccessorTable().getFieldAccessor(field).clear(this);
        return (T)this;
    }

    @Override
    public int getRepeatedFieldCount(Descriptors.FieldDescriptor field) {
        return this.internalGetFieldAccessorTable().getFieldAccessor(field).getRepeatedCount(this);
    }

    @Override
    public Object getRepeatedField(Descriptors.FieldDescriptor field, int index) {
        return this.internalGetFieldAccessorTable().getFieldAccessor(field).getRepeated(this, index);
    }

    public T setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.assertMutable();
        this.internalGetFieldAccessorTable().getFieldAccessor(field).setRepeated(this, index, value);
        return (T)this;
    }

    public T addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.assertMutable();
        this.internalGetFieldAccessorTable().getFieldAccessor(field).addRepeated(this, value);
        return (T)this;
    }

    @Override
    public Object getMutableField(Descriptors.FieldDescriptor field) {
        this.assertMutable();
        return this.internalGetFieldAccessorTable().getFieldAccessor(field).getMutable(this);
    }

    @Override
    public MutableMessage newMessageForField(Descriptors.FieldDescriptor field) {
        return this.internalGetFieldAccessorTable().getFieldAccessor(field).newMessage();
    }

    public T setUnknownFields(UnknownFieldSet unknownFields) {
        UninterpretedTags uninterpreted = new UninterpretedTags();
        ProtocolSource source = new ProtocolSource(unknownFields.toByteArray());
        while (source.remaining() > 0) {
            int wireTag = source.getVarInt();
            byte[] data = source.getUninterpreted(wireTag);
            uninterpreted.putBytes(wireTag, data);
        }
        ProtocolSupport.setUninterpreted(this, uninterpreted);
        return (T)this;
    }

    @Override
    public UnknownFieldSet getUnknownFields() {
        UninterpretedTags unknownFields = ProtocolSupport.getUninterpreted(this);
        if (unknownFields == null) {
            return UnknownFieldSet.getDefaultInstance();
        }
        ProtocolSink sink = new ProtocolSink(new byte[unknownFields.encodingSize()]);
        unknownFields.put(sink);
        try {
            return UnknownFieldSet.newBuilder().mergeFrom(sink.array(), 0, sink.position()).build();
        }
        catch (InvalidProtocolBufferException e) {
            logger.warning("Unknown fields are not in valid protobuf wire format: " + e.toString());
            return UnknownFieldSet.getDefaultInstance();
        }
    }

    protected String internalGetImmutableClassName() {
        throw new UnsupportedOperationException("Not implemented for this class");
    }

    @Override
    public Message immutableCopy() {
        try {
            String immutableClassName = this.internalGetImmutableClassName();
            Class<?> immutableClass = Class.forName(immutableClassName);
            Method defaultInstanceMethod = immutableClass.getMethod("getDefaultInstance", new Class[0]);
            Message defaultInstance = (Message)defaultInstanceMethod.invoke(null, new Object[0]);
            return defaultInstance.newBuilderForType().mergeFrom(this.toByteArray()).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert to immutable type.", e);
        }
    }

    @Override
    protected boolean isProto1Group() {
        return false;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ProtocolMessage.formattedHex[i] = String.format("0x%02x ", i);
        }
        logger = Logger.getLogger(ProtocolMessage.class.getName());
        FLAGS_DEFAULT = EnumSet.of(PrintFlag.ALLOW_NULL);
        FLAGS_WITH_INDEX = EnumSet.of(PrintFlag.SHOW_ELEMENT_NUMBERS);
    }

    protected static class FieldAccessorTable {
        private Descriptors.Descriptor messageDescriptor;
        private FieldAccessor[] fieldAccessors;

        public FieldAccessorTable(Class<?> messageClass, ProtocolType protocolType, String descriptorOuterClass, int ... pathToMessageDescriptor) {
            int i;
            Descriptors.FileDescriptor file;
            try {
                Class<?> clazz = messageClass.getClassLoader().loadClass(descriptorOuterClass);
                file = (Descriptors.FileDescriptor)clazz.getField("descriptor").get(null);
            }
            catch (Exception e) {
                logger.warning("Failed to load proto2 descriptors in " + descriptorOuterClass);
                return;
            }
            Descriptors.Descriptor messageDescriptor = file.getMessageTypes().get(pathToMessageDescriptor[0]);
            for (i = 1; i < pathToMessageDescriptor.length; ++i) {
                messageDescriptor = messageDescriptor.getNestedTypes().get(pathToMessageDescriptor[i]);
            }
            this.messageDescriptor = messageDescriptor;
            this.fieldAccessors = new FieldAccessor[messageDescriptor.getFields().size()];
            for (i = 0; i < messageDescriptor.getFields().size(); ++i) {
                Descriptors.FieldDescriptor field = messageDescriptor.getFields().get(i);
                ProtocolType.FieldType fieldType = protocolType.getTagInfo(field.getNumber());
                if (!field.isRepeated()) {
                    if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                        this.fieldAccessors[i] = new SingularMessageFieldAccessor(fieldType);
                        continue;
                    }
                    this.fieldAccessors[i] = new SingularPrimitiveFieldAccessor(field, fieldType);
                    continue;
                }
                this.fieldAccessors[i] = field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? new RepeatedMessageFieldAccessor(fieldType) : new RepeatedPrimitiveFieldAccessor(field, fieldType);
            }
        }

        public Descriptors.Descriptor getDescriptor() {
            if (this.messageDescriptor == null) {
                throw new RuntimeException("Proto2 descriptors are not available.");
            }
            return this.messageDescriptor;
        }

        public FieldAccessor getFieldAccessor(Descriptors.FieldDescriptor field) {
            assert (field.getContainingType() == this.messageDescriptor);
            return this.fieldAccessors[field.getIndex()];
        }

        private static Object readPackedField(CodedInputStream input, Descriptors.FieldDescriptor field) throws IOException {
            switch (field.getType()) {
                case BOOL: {
                    return input.readBool();
                }
                case INT32: {
                    return input.readInt32();
                }
                case UINT32: {
                    return input.readUInt32();
                }
                case SINT32: {
                    return input.readSInt32();
                }
                case FIXED32: {
                    return input.readFixed32();
                }
                case SFIXED32: {
                    return input.readSFixed32();
                }
                case INT64: {
                    return input.readInt64();
                }
                case UINT64: {
                    return input.readUInt64();
                }
                case SINT64: {
                    return input.readSInt64();
                }
                case FIXED64: {
                    return input.readFixed64();
                }
                case SFIXED64: {
                    return input.readSFixed64();
                }
                case FLOAT: {
                    return Float.valueOf(input.readFloat());
                }
                case DOUBLE: {
                    return input.readDouble();
                }
                case ENUM: {
                    Descriptors.EnumValueDescriptor converted = field.getEnumType().findValueByNumber(input.readEnum());
                    if (converted == null) {
                        return field.getEnumType().getValues().get(0);
                    }
                    return converted;
                }
            }
            throw new RuntimeException("Unexpected packed field type: " + (Object)((Object)field.getType()));
        }

        private static void writePackedField(CodedOutputStream output, Descriptors.FieldDescriptor field, Object value) throws IOException {
            switch (field.getType()) {
                case BOOL: {
                    output.writeBoolNoTag((Boolean)value);
                    break;
                }
                case INT32: {
                    output.writeInt32NoTag((Integer)value);
                    break;
                }
                case UINT32: {
                    output.writeUInt32NoTag((Integer)value);
                    break;
                }
                case SINT32: {
                    output.writeSInt32NoTag((Integer)value);
                    break;
                }
                case FIXED32: {
                    output.writeFixed32NoTag((Integer)value);
                    break;
                }
                case SFIXED32: {
                    output.writeSFixed32NoTag((Integer)value);
                    break;
                }
                case INT64: {
                    output.writeInt64NoTag((Long)value);
                    break;
                }
                case UINT64: {
                    output.writeUInt64NoTag((Long)value);
                    break;
                }
                case SINT64: {
                    output.writeSInt64NoTag((Long)value);
                    break;
                }
                case FIXED64: {
                    output.writeFixed64NoTag((Long)value);
                    break;
                }
                case SFIXED64: {
                    output.writeSFixed64NoTag((Long)value);
                    break;
                }
                case FLOAT: {
                    output.writeFloatNoTag(((Float)value).floatValue());
                    break;
                }
                case DOUBLE: {
                    output.writeDoubleNoTag((Double)value);
                    break;
                }
                case ENUM: {
                    output.writeEnumNoTag(((Descriptors.EnumValueDescriptor)value).getNumber());
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected packed field type: " + (Object)((Object)field.getType()));
                }
            }
        }

        static List<Object> convertPackedToList(byte[] data, Descriptors.FieldDescriptor field) {
            ArrayList<Object> result = new ArrayList<Object>();
            CodedInputStream input = CodedInputStream.newInstance(data);
            try {
                while (input.getBytesUntilLimit() > 0) {
                    result.add(FieldAccessorTable.readPackedField(input, field));
                }
            }
            catch (InvalidProtocolBufferException e) {
                logger.warning("Packed field " + field.getFullName() + " contains invalid data");
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected IOException when parsing from byte array", e);
            }
            return result;
        }

        static byte[] convertListToPacked(List<Object> list, Descriptors.FieldDescriptor field) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            CodedOutputStream output = CodedOutputStream.newInstance(byteStream);
            for (Object item : list) {
                try {
                    FieldAccessorTable.writePackedField(output, field, item);
                    output.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected IOException when writing into a byte array", e);
                }
            }
            return byteStream.toByteArray();
        }

        private static class RepeatedMessageFieldAccessor
        extends RepeatedFieldAccessor {
            public RepeatedMessageFieldAccessor(ProtocolType.FieldType fieldType) {
                super(fieldType);
            }

            @Override
            public MutableMessage newMessage() {
                return ProtocolSupport.newInstance(this.fieldType.getSubclass());
            }
        }

        private static class SingularMessageFieldAccessor
        extends SingularFieldAccessor {
            private MutableMessage defaultInstance;

            public SingularMessageFieldAccessor(ProtocolType.FieldType fieldType) {
                super(fieldType);
                this.defaultInstance = ProtocolSupport.getDefaultInstance(fieldType.getSubclass());
            }

            @Override
            public Object get(ProtocolMessage<?> message) {
                Object result = super.get(message);
                if (result == null) {
                    return this.defaultInstance;
                }
                return result;
            }

            @Override
            public Object getMutable(ProtocolMessage<?> message) {
                if (this.has(message)) {
                    return this.get(message);
                }
                MutableMessage object = this.newMessage();
                this.set(message, object);
                return object;
            }

            @Override
            public MutableMessage newMessage() {
                return ProtocolSupport.newInstance(this.fieldType.getSubclass());
            }
        }

        private static class RepeatedPrimitiveFieldAccessor
        extends RepeatedFieldAccessor {
            private Descriptors.FieldDescriptor field;

            private RepeatedPrimitiveFieldAccessor(Descriptors.FieldDescriptor field, ProtocolType.FieldType fieldType) {
                super(fieldType);
                this.field = field;
            }

            @Override
            public int getRepeatedCount(ProtocolMessage<?> message) {
                if (this.field.isPacked()) {
                    return FieldAccessorTable.convertPackedToList((byte[])this.fieldType.getSingleValue(message), this.field).size();
                }
                return super.getRepeatedCount(message);
            }

            @Override
            public Object getRepeated(ProtocolMessage<?> message, int index) {
                if (this.field.isPacked()) {
                    return FieldAccessorTable.convertPackedToList((byte[])this.fieldType.getSingleValue(message), this.field).get(index);
                }
                return ProtocolType.convertToProto2Reflection(this.field, super.getRepeated(message, index));
            }

            @Override
            public void setRepeated(ProtocolMessage<?> message, int index, Object value) {
                if (this.field.isPacked()) {
                    List<Object> list = FieldAccessorTable.convertPackedToList((byte[])this.fieldType.getSingleValue(message), this.field);
                    list.set(index, value);
                    this.fieldType.setSingleValue(message, FieldAccessorTable.convertListToPacked(list, this.field));
                } else {
                    super.setRepeated(message, index, ProtocolType.convertFromProto2Reflection(this.field, value));
                }
            }

            @Override
            public void addRepeated(ProtocolMessage<?> message, Object value) {
                if (this.field.isPacked()) {
                    List<Object> list = FieldAccessorTable.convertPackedToList((byte[])this.fieldType.getSingleValue(message), this.field);
                    list.add(value);
                    this.fieldType.setSingleValue(message, FieldAccessorTable.convertListToPacked(list, this.field));
                } else {
                    super.addRepeated(message, ProtocolType.convertFromProto2Reflection(this.field, value));
                }
            }
        }

        private static class SingularPrimitiveFieldAccessor
        extends SingularFieldAccessor {
            private Descriptors.FieldDescriptor field;

            private SingularPrimitiveFieldAccessor(Descriptors.FieldDescriptor field, ProtocolType.FieldType fieldType) {
                super(fieldType);
                this.field = field;
            }

            @Override
            public Object get(ProtocolMessage<?> message) {
                return ProtocolType.convertToProto2Reflection(this.field, super.get(message));
            }

            @Override
            public void set(ProtocolMessage<?> message, Object value) {
                super.set(message, ProtocolType.convertFromProto2Reflection(this.field, value));
            }
        }

        private static class RepeatedFieldAccessor
        implements FieldAccessor {
            protected final ProtocolType.FieldType fieldType;

            public RepeatedFieldAccessor(ProtocolType.FieldType fieldType) {
                this.fieldType = fieldType;
            }

            @Override
            public Object get(ProtocolMessage<?> message) {
                int count = this.getRepeatedCount(message);
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < count; ++i) {
                    list.add(this.getRepeated(message, i));
                }
                return Collections.unmodifiableList(list);
            }

            @Override
            public void set(ProtocolMessage<?> message, Object value) {
                this.clear(message);
                List list = (List)value;
                for (int i = 0; i < list.size(); ++i) {
                    this.addRepeated(message, list.get(i));
                }
            }

            @Override
            public void clear(ProtocolMessage<?> message) {
                this.fieldType.clear(message);
            }

            @Override
            public boolean has(ProtocolMessage<?> message) {
                throw new UnsupportedOperationException("hasField() called on a repeated field.");
            }

            @Override
            public int getRepeatedCount(ProtocolMessage<?> message) {
                return this.fieldType.size(message);
            }

            @Override
            public Object getRepeated(ProtocolMessage<?> message, int index) {
                return this.fieldType.getNthValue(message, index);
            }

            @Override
            public void setRepeated(ProtocolMessage<?> message, int index, Object value) {
                this.fieldType.setNthValue(message, index, value);
            }

            @Override
            public void addRepeated(ProtocolMessage<?> message, Object value) {
                this.fieldType.addValue(message, value);
            }

            @Override
            public Object getMutable(ProtocolMessage<?> message) {
                throw new UnsupportedOperationException("getMutableField() called on a repeated field.");
            }

            @Override
            public MutableMessage newMessage() {
                throw new UnsupportedOperationException("newMessageForField() called on a non-message field.");
            }
        }

        private static class SingularFieldAccessor
        implements FieldAccessor {
            protected final ProtocolType.FieldType fieldType;

            public SingularFieldAccessor(ProtocolType.FieldType fieldType) {
                this.fieldType = fieldType;
            }

            @Override
            public Object get(ProtocolMessage<?> message) {
                return this.fieldType.getSingleValue(message);
            }

            @Override
            public void set(ProtocolMessage<?> message, Object value) {
                this.fieldType.setSingleValue(message, value);
            }

            @Override
            public void clear(ProtocolMessage<?> message) {
                this.fieldType.clear(message);
            }

            @Override
            public boolean has(ProtocolMessage<?> message) {
                return this.fieldType.size(message) > 0;
            }

            @Override
            public int getRepeatedCount(ProtocolMessage<?> message) {
                throw new UnsupportedOperationException("getRepeatedFieldCount() called on a singular field.");
            }

            @Override
            public Object getRepeated(ProtocolMessage<?> message, int index) {
                throw new UnsupportedOperationException("getRepeatedField() called on a singular field.");
            }

            @Override
            public void setRepeated(ProtocolMessage<?> message, int index, Object value) {
                throw new UnsupportedOperationException("setRepeatedField() called on a singular field.");
            }

            @Override
            public void addRepeated(ProtocolMessage<?> message, Object value) {
                throw new UnsupportedOperationException("addRepeatedField() called on a singular field.");
            }

            @Override
            public Object getMutable(ProtocolMessage<?> message) {
                throw new UnsupportedOperationException("getMutableField() called on a non-message field.");
            }

            @Override
            public MutableMessage newMessage() {
                throw new UnsupportedOperationException("newMessageForField() called on a non-message field.");
            }
        }

        private static interface FieldAccessor {
            public Object get(ProtocolMessage<?> var1);

            public void set(ProtocolMessage<?> var1, Object var2);

            public void clear(ProtocolMessage<?> var1);

            public boolean has(ProtocolMessage<?> var1);

            public int getRepeatedCount(ProtocolMessage<?> var1);

            public Object getRepeated(ProtocolMessage<?> var1, int var2);

            public void setRepeated(ProtocolMessage<?> var1, int var2, Object var3);

            public void addRepeated(ProtocolMessage<?> var1, Object var2);

            public Object getMutable(ProtocolMessage<?> var1);

            public MutableMessage newMessage();
        }
    }

    public static class XmlVisitor
    extends AbstractVisitor {
        protected XmlVisitor(StringBuilder sb, String prefix) {
            super(sb, prefix, EnumSet.noneOf(PrintFlag.class));
        }

        @Override
        public void visitBoolean(ProtocolType.FieldType ti, int index, boolean value) {
            this.header(ti, index);
            this.append(" bool=\"", value, "\"/>");
        }

        @Override
        public void visitInteger(ProtocolType.FieldType ti, int index, int value) {
            this.header(ti, index);
            this.append(" int=\"", value, "\"/>");
        }

        @Override
        public void visitLong(ProtocolType.FieldType ti, int index, long value) {
            this.header(ti, index);
            this.append(" long=\"", value, "\"/>");
        }

        @Override
        public void visitByteArray(ProtocolType.FieldType ti, int index, byte[] value) {
            this.header(ti, index);
            this.append(" data=\"", XmlEscapers.xmlEscaper().escape(Protocol.toStringUtf8(value)), "\"/>");
        }

        @Override
        public void visitString(ProtocolType.FieldType ti, int index, String value) {
            this.header(ti, index);
            this.append(" data=\"", XmlEscapers.xmlEscaper().escape(value), "\"/>");
        }

        @Override
        public void visitFloat(ProtocolType.FieldType ti, int index, float value) {
            this.header(ti, index);
            this.append(" float=\"", Float.valueOf(value), "\"/>");
        }

        @Override
        public void visitDouble(ProtocolType.FieldType ti, int index, double value) {
            this.header(ti, index);
            this.append(" double=\"", value, "\"/>");
        }

        @Override
        public void visitGroup(ProtocolType.FieldType ti, int index, ProtocolMessage value) {
            this.visitCollection(ti, index, value, ">", "</" + XmlEscapers.xmlEscaper().escape(ti.getName()) + ">");
        }

        @Override
        public void visitForeign(ProtocolType.FieldType ti, int index, ProtocolMessage value) {
            this.visitGroup(ti, index, value);
        }

        @Override
        protected void header(ProtocolType.FieldType ti, int index) {
            this.separator();
            this.prefix();
            this.append("<", XmlEscapers.xmlEscaper().escape(ti.getName()));
        }
    }

    public static class BoundedAsciiVisitor
    extends AsciiVisitor {
        int maxChars = 0;

        BoundedAsciiVisitor(StringBuilder sb, String prefix, Set<PrintFlag> flags, int maxChars) {
            super(sb, prefix, flags);
            this.maxChars = maxChars;
        }

        private int availableSpace() {
            return this.maxChars - this.sb.length();
        }

        @Override
        public boolean canAccept() {
            return this.availableSpace() > 0;
        }

        @Override
        public void visitByteArray(ProtocolType.FieldType ti, int index, byte[] value) {
            this.header(ti, index);
            byte[] bytesToStore = this.binaryString ? ti.getRawByteArray(this.node, index) : value;
            int nBytes = Math.max(0, Math.min(bytesToStore.length, this.availableSpace() - 4));
            String stringValue = this.binaryString ? new String(ti.getRawByteArray(this.node, index), 0, 0, nBytes) : ProtocolSupport.toStringUtf8(value, 0, nBytes);
            this.appendString(stringValue);
        }
    }

    public static class AsciiVisitor
    extends AbstractVisitor {
        public AsciiVisitor(StringBuilder sb, String prefix, Set<PrintFlag> flags) {
            super(sb, prefix, flags);
        }

        @Override
        public void visitBoolean(ProtocolType.FieldType ti, int index, boolean value) {
            this.header(ti, index);
            this.append(": ", value);
        }

        @Override
        public void visitInteger(ProtocolType.FieldType ti, int index, int value) {
            this.header(ti, index);
            this.append(": ");
            ProtocolType.FieldBaseType type = ti.getBaseType();
            Class<? extends Enum> enumType = ti.getEnumType();
            if (enumType != null && this.flags.contains((Object)PrintFlag.PRINT_ENUMS)) {
                try {
                    Method method = enumType.getMethod("valueOf", Integer.TYPE);
                    Enum e = (Enum)method.invoke(null, value);
                    if (e != null) {
                        this.append(e);
                        return;
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!this.numberAlwaysDecimal && (value >= 2000000000 || value <= -2000000000 || type.isFixed())) {
                this.append("0x", Integer.toHexString(value));
            } else {
                this.append(value);
            }
        }

        @Override
        public void visitLong(ProtocolType.FieldType ti, int index, long value) {
            this.header(ti, index);
            this.append(": ");
            ProtocolType.FieldBaseType type = ti.getBaseType();
            if (!this.numberAlwaysDecimal && (value >= 2000000000L || value <= -2000000000L || type.isFixed())) {
                this.append("0x", Long.toHexString(value));
            } else {
                this.append(value);
            }
        }

        @Override
        public void visitString(ProtocolType.FieldType ti, int index, String value) {
            this.header(ti, index);
            this.appendString(this.binaryString ? new String(ti.getRawByteArray(this.node, index), 0) : value);
        }

        @Override
        public void visitFloat(ProtocolType.FieldType ti, int index, float value) {
            this.header(ti, index);
            this.append(": ", Float.valueOf(value), "f");
        }

        @Override
        public void visitDouble(ProtocolType.FieldType ti, int index, double value) {
            this.header(ti, index);
            this.append(": ", value);
        }

        @Override
        public void visitByteArray(ProtocolType.FieldType ti, int index, byte[] value) {
            this.header(ti, index);
            String stringValue = this.binaryString ? new String(ti.getRawByteArray(this.node, index), 0) : ProtocolSupport.toStringUtf8(value);
            this.appendString(stringValue);
        }

        @Override
        public void visitGroup(ProtocolType.FieldType ti, int index, ProtocolMessage value) {
            this.visitCollection(ti, index, value, " {", "}");
        }

        @Override
        public void visitForeign(ProtocolType.FieldType ti, int index, ProtocolMessage value) {
            this.visitCollection(ti, index, value, " <", ">");
        }

        @Override
        public void visitNull() {
            this.separator();
            this.prefix();
            this.append("ILLEGAL_NULL_VALUE");
        }

        @Override
        protected void header(ProtocolType.FieldType ti, int index) {
            this.separator();
            this.prefix();
            if (ti instanceof MessageSet.FieldType) {
                this.append("[", ti.getName(), "]");
            } else {
                this.append(ti.getName());
            }
            if (this.flags.contains((Object)PrintFlag.SHOW_ELEMENT_NUMBERS) && index >= 0 && ti.getPresence() == ProtocolType.Presence.REPEATED) {
                this.append("(", index, ")");
            }
        }
    }

    public static abstract class AbstractVisitor
    implements MessageVisitor {
        protected final StringBuilder sb;
        protected final Set<PrintFlag> flags;
        protected final char separator;
        protected final String newline;
        protected final boolean numberAlwaysDecimal;
        protected final boolean escapeString;
        protected final boolean binaryString;
        protected final String prefix;
        private final String alignment = "  ";
        private int depth = -1;
        private boolean needSeparator = false;
        protected ProtocolMessage node;

        protected AbstractVisitor(StringBuilder sb, String prefix, Set<PrintFlag> flags) {
            this.sb = sb;
            this.flags = flags;
            this.separator = (char)(flags.contains((Object)PrintFlag.FLATTEN) ? 44 : 10);
            this.newline = flags.contains((Object)PrintFlag.FLATTEN) ? "" : "\n";
            this.numberAlwaysDecimal = flags.contains((Object)PrintFlag.NUMBERS_ALWAYS_DECIMAL);
            this.escapeString = !flags.contains((Object)PrintFlag.NO_ESCAPE_STRINGS);
            this.binaryString = flags.contains((Object)PrintFlag.BINARY_STRINGS);
            this.prefix = prefix;
        }

        public void visit(ProtocolMessage protocolMessage) {
            boolean neededSeparator = this.needSeparator;
            this.needSeparator = false;
            ProtocolMessage previousNode = this.node;
            this.node = protocolMessage;
            ++this.depth;
            this.newline();
            if (protocolMessage != null) {
                ProtocolType.visit(protocolMessage, this);
                this.newline();
            } else {
                this.visitNull();
            }
            --this.depth;
            this.needSeparator = neededSeparator;
            this.node = previousNode;
        }

        protected void visitCollection(ProtocolType.FieldType ti, int index, ProtocolMessage collection, String opener, String closer) {
            this.header(ti, index);
            if (collection == null) {
                this.visit(collection);
            } else {
                this.append(opener);
                this.visit(collection);
                this.prefix();
                this.append(closer);
            }
        }

        public boolean canAccept() {
            return true;
        }

        @Override
        public boolean shouldVisitField(ProtocolType.FieldType ti, int count) {
            return this.canAccept();
        }

        @Override
        public abstract void visitForeign(ProtocolType.FieldType var1, int var2, ProtocolMessage var3);

        @Override
        public void visitRawMessage(ByteBuffer value) {
            while (value.remaining() > 0 && this.canAccept()) {
                this.separator();
                this.prefix();
                for (int j = 0; j < 16 && value.remaining() > 0 && this.canAccept(); ++j) {
                    this.append(formattedHex[value.get() & 0xFF]);
                }
            }
        }

        protected void visitNull() {
            throw new NullPointerException();
        }

        protected void prefix() {
            if (this.prefix != null) {
                this.append(this.prefix);
                for (int i = 0; i < this.depth; ++i) {
                    this.append("  ");
                }
            }
        }

        protected void separator() {
            if (this.needSeparator) {
                this.append(Character.valueOf(this.separator));
            }
            this.needSeparator = true;
        }

        private void newline() {
            if (this.depth > 0) {
                this.append(this.newline);
            }
        }

        protected void append(Object ... parts) {
            for (Object part : parts) {
                this.sb.append(part.toString());
            }
        }

        protected void appendString(String s) {
            this.append(": \"", this.escapeString ? SourceCodeEscapers.javaStringEscaperWithOctal().escape(s) : s, "\"");
        }

        protected abstract void header(ProtocolType.FieldType var1, int var2);

        public void visit(ByteBuffer message) {
            this.visitRawMessage(message);
        }
    }

    public static enum PrintFlag {
        SHOW_ELEMENT_NUMBERS,
        PRINT_ENUMS,
        FLATTEN,
        NUMBERS_ALWAYS_DECIMAL,
        NO_ESCAPE_STRINGS,
        BINARY_STRINGS,
        ALLOW_NULL;

    }
}

