/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.cloud.dashboard.repository.eureka;

import com.github.vanroy.cloud.dashboard.model.Application;
import com.github.vanroy.cloud.dashboard.model.InstanceHistory;
import com.github.vanroy.cloud.dashboard.repository.RegistryRepository;
import com.github.vanroy.cloud.dashboard.repository.eureka.EurekaRepository;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Pair;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LocaleEurekaRepository
extends EurekaRepository
implements RegistryRepository {
    private final PeerAwareInstanceRegistry registry;
    private Function<Pair<Long, String>, InstanceHistory> TO_REGISTRY_HISTORY = history -> new InstanceHistory((String)history.second(), new Date((Long)history.first()));

    public LocaleEurekaRepository(PeerAwareInstanceRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Collection<Application> findAll() {
        return this.registry.getSortedApplications().stream().map(this.TO_APPLICATION).collect(Collectors.toList());
    }

    @Override
    public Application findByName(String name) {
        return (Application)this.TO_APPLICATION.apply(this.registry.getApplication(name));
    }

    @Override
    public List<InstanceHistory> getCanceledInstanceHistory() {
        return this.registry.getLastNCanceledInstances().stream().map(this.TO_REGISTRY_HISTORY).collect(Collectors.toList());
    }

    @Override
    public List<InstanceHistory> getRegisteredInstanceHistory() {
        return this.registry.getLastNRegisteredInstances().stream().map(this.TO_REGISTRY_HISTORY).collect(Collectors.toList());
    }

    @Override
    protected InstanceInfo findInstanceInfo(String id) {
        String[] instanceIds = id.split("_", 2);
        return this.registry.getInstanceByAppAndId(instanceIds[0], instanceIds[1].replaceAll("_", "."));
    }
}

