/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.cloud.dashboard.repository.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.Tag;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.InstanceStatus;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationDescription;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentResourceDescription;
import com.github.vanroy.cloud.dashboard.model.Application;
import com.github.vanroy.cloud.dashboard.model.Instance;
import com.github.vanroy.cloud.dashboard.repository.ApplicationRepository;
import com.github.vanroy.cloud.dashboard.repository.aws.BeanstalkProperties;
import com.github.vanroy.cloud.dashboard.repository.aws.BeanstalkRepository$AjcClosure1;
import com.github.vanroy.cloud.dashboard.repository.aws.BeanstalkRepository$AjcClosure3;
import com.github.vanroy.cloud.dashboard.repository.aws.BeanstalkRepository$AjcClosure5;
import com.github.vanroy.cloud.dashboard.repository.aws.BeanstalkRepository$AjcClosure7;
import com.github.vanroy.cloud.dashboard.repository.aws.BeanstalkRepository$AjcClosure9;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.aspectj.AnnotationCacheAspect;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={BeanstalkProperties.class})
public class BeanstalkRepository
implements ApplicationRepository {
    private static final Logger LOGGER;
    @Autowired
    private BeanstalkProperties properties;
    private Function<ApplicationDescription, Application> TO_APPLICATION = app -> {
        if (app == null) {
            return null;
        }
        return this.getApplication(app.getApplicationName());
    };
    private Function<com.amazonaws.services.ec2.model.Instance, Instance> TO_INSTANCE = instance -> {
        if (instance == null) {
            return null;
        }
        return new Instance("", instance.getInstanceId(), instance.getInstanceId(), this.getInstanceStatus(instance.getInstanceId()));
    };
    private Function<InstanceState, String> TO_STATUS = state -> {
        switch (state.getName()) {
            case "pending": {
                return "STARTING";
            }
            case "running": {
                return "UP";
            }
            case "shutting-down": {
                return "OUT_OF_SERVICE";
            }
            case "terminated": {
                return "OUT_OF_SERVICE";
            }
            case "stopping": {
                return "DOWN";
            }
            case "stopped": {
                return "DOWN";
            }
        }
        return "UNKNOWN";
    };
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        BeanstalkRepository.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(BeanstalkRepository.class);
    }

    @Override
    public Collection<Application> findAll() {
        DescribeApplicationsResult result = this.getBeanstalk().describeApplications();
        LOGGER.info("Find applications : {}", (Object)result.getApplications().size());
        return result.getApplications().parallelStream().map(this.TO_APPLICATION).sorted(Comparator.comparing(Application::getName)).collect(Collectors.toList());
    }

    @Override
    public Application findByName(String name) {
        return this.TO_APPLICATION.apply((ApplicationDescription)this.getBeanstalk().describeApplications(new DescribeApplicationsRequest().withApplicationNames(new String[]{name})).getApplications().get(0));
    }

    @Override
    public String getApplicationCircuitBreakerStreamUrl(String name) {
        return null;
    }

    @Override
    public String getInstanceCircuitBreakerStreamUrl(String instanceId) {
        return null;
    }

    @Override
    public Instance findInstance(String id) {
        return this.TO_INSTANCE.apply((com.amazonaws.services.ec2.model.Instance)((Reservation)this.getEC2().describeInstances(new DescribeInstancesRequest().withInstanceIds(new String[]{id})).getReservations().get(0)).getInstances().get(0));
    }

    @Override
    public String getInstanceManagementUrl(String id) {
        BeanstalkProperties.Management management = this.properties.getInstances().getManagement();
        String privateDns = this.getInstancePrivateDns(id);
        return String.valueOf(management.getScheme()) + "://" + privateDns + ":" + management.getPort() + management.getPath();
    }

    @Cacheable(value={"awsBeanstalkClient"})
    private AWSElasticBeanstalk getBeanstalk() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (AWSElasticBeanstalk)AnnotationCacheAspect.aspectOf().ajc$around$org_springframework_cache_aspectj_AbstractCacheAspect$1$2bc714b5((Object)this, (AroundClosure)new BeanstalkRepository$AjcClosure1(objectArray), joinPoint);
    }

    @Cacheable(value={"awsEC2Client"})
    private AmazonEC2 getEC2() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (AmazonEC2)AnnotationCacheAspect.aspectOf().ajc$around$org_springframework_cache_aspectj_AbstractCacheAspect$1$2bc714b5((Object)this, (AroundClosure)new BeanstalkRepository$AjcClosure3(objectArray), joinPoint);
    }

    @Cacheable(value={"awsCloudformationStacks"})
    private List<Stack> getStacks() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (List)AnnotationCacheAspect.aspectOf().ajc$around$org_springframework_cache_aspectj_AbstractCacheAspect$1$2bc714b5((Object)this, (AroundClosure)new BeanstalkRepository$AjcClosure5(objectArray), joinPoint);
    }

    @Cacheable(value={"awsEC2InstancePrivateDns"})
    private String getInstancePrivateDns(String instanceId) {
        String string = instanceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (String)AnnotationCacheAspect.aspectOf().ajc$around$org_springframework_cache_aspectj_AbstractCacheAspect$1$2bc714b5((Object)this, (AroundClosure)new BeanstalkRepository$AjcClosure7(objectArray), joinPoint);
    }

    @Cacheable(value={"awsBeanstalkApplications"})
    private Application getApplication(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Application)AnnotationCacheAspect.aspectOf().ajc$around$org_springframework_cache_aspectj_AbstractCacheAspect$1$2bc714b5((Object)this, (AroundClosure)new BeanstalkRepository$AjcClosure9(objectArray), joinPoint);
    }

    private List<Instance> getInstances(String appName) {
        DescribeEnvironmentsRequest envRequest = new DescribeEnvironmentsRequest().withApplicationName(appName);
        List environments = this.getBeanstalk().describeEnvironments(envRequest).getEnvironments();
        if (environments == null || environments.isEmpty()) {
            return Collections.emptyList();
        }
        DescribeEnvironmentResourcesRequest request = new DescribeEnvironmentResourcesRequest();
        if (StringUtils.hasText((String)this.properties.getEnvironment())) {
            Optional<EnvironmentDescription> environment = environments.stream().filter(e -> e.getEnvironmentName().matches(this.properties.getEnvironment())).findFirst();
            if (!environment.isPresent()) {
                return Collections.emptyList();
            }
            request.withEnvironmentName(environment.get().getEnvironmentName());
        }
        if (this.properties.getEnvironmentTags() != null && !this.properties.getEnvironmentTags().isEmpty()) {
            List environmentIds = environments.stream().map(EnvironmentDescription::getEnvironmentId).collect(Collectors.toList());
            Optional<String> oEnvironmentId = this.getStacks().stream().map(Stack::getTags).map(tags -> tags.stream().collect(Collectors.toMap(Tag::getKey, Tag::getValue))).filter(tags -> {
                for (Map.Entry<String, String> entry : this.properties.getEnvironmentTags().entrySet()) {
                    if (entry.getValue().equalsIgnoreCase((String)tags.get(entry.getKey()))) continue;
                    return false;
                }
                return true;
            }).map(tags -> (String)tags.get("elasticbeanstalk:environment-id")).filter(environmentIds::contains).findFirst();
            if (!oEnvironmentId.isPresent()) {
                return Collections.emptyList();
            }
            request.withEnvironmentId(oEnvironmentId.get());
        }
        EnvironmentResourceDescription resources = this.getBeanstalk().describeEnvironmentResources(request).getEnvironmentResources();
        return resources.getInstances().stream().map(instance -> new Instance("", instance.getId(), instance.getId(), this.getInstanceStatus(instance.getId()))).collect(Collectors.toList());
    }

    private String getInstanceStatus(String ... id) {
        try {
            return this.TO_STATUS.apply(((InstanceStatus)this.getEC2().describeInstanceStatus(new DescribeInstanceStatusRequest().withInstanceIds(id)).getInstanceStatuses().get(0)).getInstanceState());
        }
        catch (AmazonServiceException e) {
            LOGGER.warn("Instance not found", (Throwable)e);
            return "UNKNOWN";
        }
    }

    static final /* synthetic */ AWSElasticBeanstalk getBeanstalk_aroundBody0(BeanstalkRepository ajc$this, JoinPoint joinPoint) {
        AWSCredentials credentials = new DefaultAWSCredentialsProviderChain().getCredentials();
        AWSElasticBeanstalkClient beanstalk = new AWSElasticBeanstalkClient(credentials);
        beanstalk.setEndpoint(ajc$this.properties.getEndpoint());
        return beanstalk;
    }

    static final /* synthetic */ AmazonEC2 getEC2_aroundBody2(BeanstalkRepository ajc$this, JoinPoint joinPoint) {
        AWSCredentials credentials = new DefaultAWSCredentialsProviderChain().getCredentials();
        AmazonEC2Client ec2 = new AmazonEC2Client(credentials);
        ec2.setEndpoint(ajc$this.properties.getInstances().getEndpoint());
        return ec2;
    }

    static final /* synthetic */ List getStacks_aroundBody4(BeanstalkRepository ajc$this, JoinPoint joinPoint) {
        AWSCredentials credentials = new DefaultAWSCredentialsProviderChain().getCredentials();
        AmazonCloudFormationClient cf = new AmazonCloudFormationClient(credentials);
        cf.setEndpoint(ajc$this.properties.getCloudFormation().getEndpoint());
        ArrayList stacks = new ArrayList();
        DescribeStacksResult stacksResults = cf.describeStacks();
        stacks.addAll(stacksResults.getStacks());
        int i = 0;
        while (i < 100) {
            if (stacksResults.getNextToken() == null) {
                return stacks;
            }
            stacksResults = cf.describeStacks(new DescribeStacksRequest().withNextToken(stacksResults.getNextToken()));
            stacks.addAll(stacksResults.getStacks());
            ++i;
        }
        return stacks;
    }

    static final /* synthetic */ String getInstancePrivateDns_aroundBody6(BeanstalkRepository ajc$this, String instanceId, JoinPoint joinPoint) {
        return ((com.amazonaws.services.ec2.model.Instance)((Reservation)ajc$this.getEC2().describeInstances(new DescribeInstancesRequest().withInstanceIds(new String[]{instanceId})).getReservations().get(0)).getInstances().get(0)).getPrivateDnsName();
    }

    static final /* synthetic */ Application getApplication_aroundBody8(BeanstalkRepository ajc$this, String name, JoinPoint joinPoint) {
        return new Application(name, ajc$this.getInstances(name));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BeanstalkRepository.java", BeanstalkRepository.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getBeanstalk", "com.github.vanroy.cloud.dashboard.repository.aws.BeanstalkRepository", "", "", "", "com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk"), 105);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getEC2", "com.github.vanroy.cloud.dashboard.repository.aws.BeanstalkRepository", "", "", "", "com.amazonaws.services.ec2.AmazonEC2"), 113);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getStacks", "com.github.vanroy.cloud.dashboard.repository.aws.BeanstalkRepository", "", "", "", "java.util.List"), 121);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getInstancePrivateDns", "com.github.vanroy.cloud.dashboard.repository.aws.BeanstalkRepository", "java.lang.String", "instanceId", "", "java.lang.String"), 143);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getApplication", "com.github.vanroy.cloud.dashboard.repository.aws.BeanstalkRepository", "java.lang.String", "name", "", "com.github.vanroy.cloud.dashboard.model.Application"), 150);
    }
}

