/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.log.Log;
import wiremock.org.eclipse.jetty.util.log.Logger;
import wiremock.org.eclipse.jetty.util.thread.NonBlockingThread;

public class BlockingCallback
implements Callback {
    private static final Logger LOG = Log.getLogger(BlockingCallback.class);
    private static Throwable SUCCEEDED = new Throwable(){

        @Override
        public String toString() {
            return "SUCCEEDED";
        }
    };
    private final CountDownLatch _latch = new CountDownLatch(1);
    private final AtomicReference<Throwable> _state = new AtomicReference();

    @Override
    public void succeeded() {
        if (this._state.compareAndSet(null, SUCCEEDED)) {
            this._latch.countDown();
        }
    }

    @Override
    public void failed(Throwable cause) {
        if (this._state.compareAndSet(null, cause)) {
            this._latch.countDown();
        }
    }

    public void block() throws IOException {
        if (NonBlockingThread.isNonBlockingThread()) {
            LOG.warn("Blocking a NonBlockingThread: ", new Throwable());
        }
        try {
            this._latch.await();
            Throwable state = this._state.get();
            if (state == SUCCEEDED) {
                return;
            }
            try {
                if (state instanceof IOException) {
                    throw (IOException)state;
                }
                if (state instanceof CancellationException) {
                    throw (CancellationException)state;
                }
                throw new IOException(state);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(){
                    {
                        this.initCause(e);
                    }
                };
            }
        }
        finally {
            this._state.set(null);
        }
    }

    public String toString() {
        return String.format("%s@%x{%s}", BlockingCallback.class.getSimpleName(), this.hashCode(), this._state.get());
    }
}

