/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.protocol;

import java.io.IOException;
import wiremock.org.apache.http.HttpException;
import wiremock.org.apache.http.HttpResponse;
import wiremock.org.apache.http.HttpResponseInterceptor;
import wiremock.org.apache.http.annotation.ThreadSafe;
import wiremock.org.apache.http.protocol.HttpContext;
import wiremock.org.apache.http.protocol.HttpDateGenerator;
import wiremock.org.apache.http.util.Args;

@ThreadSafe
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

