/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.base.Joiner;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.com.google.common.collect.FluentIterable;
import wiremock.com.google.common.collect.ImmutableCollection;
import wiremock.com.google.common.collect.ImmutableList;

public class Diff {
    private final RequestPattern requestPattern;
    private final Request request;
    final Section<String> SPACER = new Section<String>(new EqualToPattern(""), "", "");
    private static Function<Section<?>, Object> EXPECTED = new Function<Section<?>, Object>(){

        @Override
        public Object apply(Section<?> input) {
            return input.getExpected();
        }
    };
    private static Function<Section<?>, Object> ACTUAL = new Function<Section<?>, Object>(){

        @Override
        public Object apply(Section<?> input) {
            return input.getActual();
        }
    };

    public Diff(RequestPattern expected, Request actual) {
        this.requestPattern = expected;
        this.request = actual;
    }

    public String toString() {
        List<StringValuePattern> bodyPatterns;
        ImmutableList.Builder builder = ImmutableList.builder();
        Section<RequestMethod> methodSection = new Section<RequestMethod>(this.requestPattern.getMethod(), this.request.getMethod(), this.requestPattern.getMethod().getName());
        builder.add(methodSection);
        Section<String> urlSection = new Section<String>(this.requestPattern.getUrlMatcher(), this.request.getUrl(), this.requestPattern.getUrlMatcher().getExpected());
        builder.add(urlSection);
        if (((Section)methodSection).shouldBeIncluded() || ((Section)urlSection).shouldBeIncluded()) {
            builder.add(this.SPACER);
        }
        boolean anyHeaderSections = false;
        Map<String, MultiValuePattern> headerPatterns = this.requestPattern.combineBasicAuthAndOtherHeaders();
        if (headerPatterns != null && !headerPatterns.isEmpty()) {
            for (String key : headerPatterns.keySet()) {
                String printedPatternValue;
                HttpHeader header = this.request.header(key);
                MultiValuePattern multiValuePattern = headerPatterns.get(header.key());
                Section<HttpHeader> section = new Section<HttpHeader>(multiValuePattern, header, printedPatternValue = header.key() + ": " + multiValuePattern.getExpected());
                if (((Section)section).shouldBeIncluded()) {
                    anyHeaderSections = true;
                }
                builder.add(section);
            }
        }
        if (anyHeaderSections) {
            builder.add(this.SPACER);
        }
        boolean anyCookieSections = false;
        if (this.requestPattern.getCookies() != null) {
            Map cookies = MoreObjects.firstNonNull(this.request.getCookies(), Collections.emptyMap());
            for (Map.Entry entry : this.requestPattern.getCookies().entrySet()) {
                String key = (String)entry.getKey();
                StringValuePattern pattern = (StringValuePattern)entry.getValue();
                Cookie cookie = MoreObjects.firstNonNull(cookies.get(key), Cookie.absent());
                Section<String> section = new Section<String>(pattern, cookie.isPresent() ? "Cookie: " + key + "=" + cookie.getValue() : "", "Cookie: " + key + "=" + pattern.getValue());
                builder.add(section);
                anyCookieSections = true;
            }
        }
        if (anyCookieSections) {
            builder.add(this.SPACER);
        }
        if ((bodyPatterns = this.requestPattern.getBodyPatterns()) != null && !bodyPatterns.isEmpty()) {
            for (StringValuePattern stringValuePattern : bodyPatterns) {
                String body = this.formatIfJsonOrXml(stringValuePattern);
                builder.add(new Section<String>(stringValuePattern, body, stringValuePattern.getExpected()));
            }
        }
        ImmutableCollection sections = builder.build();
        String string = Joiner.on("\n").join(FluentIterable.from(sections).transform(EXPECTED));
        String actual = Joiner.on("\n").join(FluentIterable.from(sections).transform(ACTUAL));
        return sections.isEmpty() ? "" : Diff.junitStyleDiffMessage(string, actual);
    }

    private String formatIfJsonOrXml(StringValuePattern pattern) {
        try {
            return pattern.getClass().equals(EqualToJsonPattern.class) ? Json.prettyPrint(this.request.getBodyAsString()) : (pattern.getClass().equals(EqualToXmlPattern.class) ? Xml.prettyPrint(this.request.getBodyAsString()) : this.request.getBodyAsString());
        }
        catch (Exception e) {
            return this.request.getBodyAsString();
        }
    }

    public static String junitStyleDiffMessage(Object expected, Object actual) {
        return String.format(" expected:<\n%s> but was:<\n%s>", expected, actual);
    }

    private class Section<V> {
        private final ValueMatcher<V> pattern;
        private final V value;
        private final String printedPatternValue;

        public Section(ValueMatcher<V> pattern, V value, String printedPatternValue) {
            this.pattern = pattern;
            this.value = value;
            this.printedPatternValue = printedPatternValue;
        }

        public Object getExpected() {
            return this.shouldBeIncluded() ? this.printedPatternValue : this.value;
        }

        public Object getActual() {
            return this.value;
        }

        private boolean shouldBeIncluded() {
            return !this.pattern.match(this.value).isExactMatch();
        }
    }
}

