/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import java.util.List;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.base.Predicate;

public class ServedStub {
    private final LoggedRequest request;
    private final ResponseDefinition responseDefinition;
    public static final Function<ServedStub, LoggedRequest> TO_LOGGED_REQUEST = new Function<ServedStub, LoggedRequest>(){

        @Override
        public LoggedRequest apply(ServedStub servedStub) {
            return servedStub.getRequest();
        }
    };
    public static final Predicate<ServedStub> NOT_MATCHED = new Predicate<ServedStub>(){

        @Override
        public boolean apply(ServedStub servedStub) {
            return servedStub.isNoExactMatch();
        }
    };

    public ServedStub(LoggedRequest request, ResponseDefinition responseDefinition) {
        this.request = request;
        this.responseDefinition = responseDefinition;
    }

    public static ServedStub noExactMatch(LoggedRequest request) {
        return new ServedStub(request, ResponseDefinition.notConfigured());
    }

    public static ServedStub exactMatch(LoggedRequest request, ResponseDefinition responseDefinition) {
        return new ServedStub(request, responseDefinition);
    }

    public boolean isNoExactMatch() {
        return !this.responseDefinition.wasConfigured();
    }

    public LoggedRequest getRequest() {
        return this.request;
    }

    public ResponseDefinition getResponseDefinition() {
        return this.responseDefinition;
    }

    public List<NearMiss> getNearMisses() {
        return null;
    }
}

