/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import java.net.URI;
import java.util.Map;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.google.common.collect.ImmutableMap;

public class ContentTypes {
    private static final Map<String, String> COMMON_MIME_TYPES = ImmutableMap.builder().put("image/jpeg", "jpeg").put("image/gif", "gif").put("image/tiff", "tiff").put("image/png", "png").put("image/x-icon", "ico").put("image/svg+xml", "svg").put("audio/x-aiff", "aiff").put("video/x-ms-asf", "asf").put("video/mpeg", "mp2").put("audio/mpeg", "mp3").put("video/quicktime", "mov").put("application/pdf", "pdf").build();

    public static String determineFileExtension(String url, ContentTypeHeader contentTypeHeader, byte[] responseBody) {
        String path;
        if (contentTypeHeader.isPresent()) {
            if (contentTypeHeader.mimeTypePart().contains("json")) {
                return "json";
            }
            if (contentTypeHeader.mimeTypePart().contains("xml")) {
                return "xml";
            }
            if (contentTypeHeader.mimeTypePart().contains("text")) {
                return "txt";
            }
            String extension = COMMON_MIME_TYPES.get(contentTypeHeader.mimeTypePart());
            if (extension != null) {
                return extension;
            }
        }
        if ((path = URI.create(url).getPath()).indexOf(46) != -1) {
            return path.substring(path.lastIndexOf(46) + 1, path.length());
        }
        return ContentTypes.determineTextFileExtension(Strings.stringFromBytes(responseBody));
    }

    public static String determineTextFileExtension(String content) {
        try {
            Json.read(content, JsonNode.class);
            return "json";
        }
        catch (Exception e) {
            try {
                Xml.read(content);
                return "xml";
            }
            catch (Exception e1) {
                return "txt";
            }
        }
    }
}

