/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class CauseParameterInExceptionCheck
extends AbstractCheck {
    public static final String MSG_KEY = "cause.parameter.in.exception";
    private Pattern classNamesRegexp = Pattern.compile(".+Exception");
    private Pattern ignoredClassNamesRegexp = Pattern.compile("");
    private Set<String> allowedCauseTypes = new HashSet<String>();
    private List<DetailAST> exceptionClassesToWarn = new LinkedList<DetailAST>();

    public CauseParameterInExceptionCheck() {
        this.allowedCauseTypes.add("Exception");
        this.allowedCauseTypes.add("Throwable");
    }

    public void setClassNamesRegexp(String classNamesRegexp) {
        String regexp = classNamesRegexp == null ? "" : classNamesRegexp;
        this.classNamesRegexp = Pattern.compile(regexp);
    }

    public void setIgnoredClassNamesRegexp(String ignoredClassNamesRegexp) {
        String regexp = ignoredClassNamesRegexp == null ? "" : ignoredClassNamesRegexp;
        this.ignoredClassNamesRegexp = Pattern.compile(regexp);
    }

    public void setAllowedCauseTypes(String[] allowedCauseTypes) {
        this.allowedCauseTypes.clear();
        for (String name : allowedCauseTypes) {
            this.allowedCauseTypes.add(name);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{14, 8};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void beginTree(DetailAST rootAST) {
        this.exceptionClassesToWarn.clear();
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 14: {
                String exceptionClassName = CauseParameterInExceptionCheck.getName(ast);
                if (!this.classNamesRegexp.matcher(exceptionClassName).matches() || this.ignoredClassNamesRegexp.matcher(exceptionClassName).matches()) break;
                this.exceptionClassesToWarn.add(ast);
                break;
            }
            case 8: {
                DetailAST exceptionClass = CauseParameterInExceptionCheck.getClassDef(ast);
                if (!this.exceptionClassesToWarn.contains(exceptionClass) || !this.hasCauseAsParameter(ast)) break;
                this.exceptionClassesToWarn.remove(exceptionClass);
                break;
            }
            default: {
                Utils.reportInvalidToken(ast.getType());
            }
        }
    }

    public void finishTree(DetailAST treeRootAST) {
        for (DetailAST classDefNode : this.exceptionClassesToWarn) {
            this.log(classDefNode, MSG_KEY, new Object[]{CauseParameterInExceptionCheck.getName(classDefNode)});
        }
    }

    private boolean hasCauseAsParameter(DetailAST ctorDefNode) {
        boolean result = false;
        DetailAST parameters = ctorDefNode.findFirstToken(20);
        for (String parameterType : CauseParameterInExceptionCheck.getParameterTypes(parameters)) {
            if (!this.allowedCauseTypes.contains(parameterType)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static List<String> getParameterTypes(DetailAST parametersAST) {
        LinkedList<String> result = new LinkedList<String>();
        for (DetailAST parametersChild : CauseParameterInExceptionCheck.getChildren(parametersAST)) {
            if (parametersChild.getType() != 21) continue;
            DetailAST parameterType = parametersChild.findFirstToken(13);
            String parameter = parameterType.getFirstChild().getText();
            result.add(parameter);
        }
        return result;
    }

    private static String getName(DetailAST classOrCtorDefNode) {
        DetailAST classNameIdent = classOrCtorDefNode.findFirstToken(58);
        return classNameIdent.getText();
    }

    private static DetailAST getClassDef(DetailAST node) {
        DetailAST curNode;
        for (curNode = node; curNode != null && curNode.getType() != 14; curNode = curNode.getParent()) {
        }
        return curNode;
    }

    private static List<DetailAST> getChildren(DetailAST node) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode = node.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            result.add(curNode);
        }
        return result;
    }
}

