/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.regex.Pattern;

public class NumericLiteralNeedsUnderscoreCheck
extends AbstractCheck {
    public static final String MSG_KEY = "numeric.literal.need.underscore";
    private static final int DEFAULT_MIN_DECIMAL_SYMBOL_LEN = 7;
    private static final int DEFAULT_MAX_DECIMAL_SYMBOLS_UNTIL_UNDERSCORE = 3;
    private static final int DEFAULT_MIN_HEX_SYMBOL_LEN = 5;
    private static final int DEFAULT_MAX_HEX_SYMBOLS_UNTIL_UNDERSCORE = 4;
    private static final int DEFAULT_MIN_BINARY_SYMBOL_LEN = 9;
    private static final int DEFAULT_MAX_BINARY_SYMBOLS_UNTIL_UNDERSCORE = 8;
    private static final Pattern DEFAULT_IGNORE_FIELD_NAME_PATTERN = Pattern.compile("serialVersionUID");
    private static final Pattern DECIMAL_SPLITTER = Pattern.compile("[\\.eE]");
    private static final Pattern HEX_SPLITTER = Pattern.compile("[\\.pP]");
    private static final int PREFIX_LENGTH = 2;
    private static final String UNEXPECTED_NUMERIC_TYPE_ERROR = "Unexpected numeric type ";
    private int minDecimalSymbolLength = 7;
    private int maxDecimalSymbolsUntilUnderscore = 3;
    private int minHexSymbolLength = 5;
    private int maxHexSymbolsUntilUnderscore = 4;
    private int minBinarySymbolLength = 9;
    private int maxBinarySymbolsUntilUnderscore = 8;
    private Pattern ignoreFieldNamePattern = DEFAULT_IGNORE_FIELD_NAME_PATTERN;

    public void setMinDecimalSymbolLength(int length) {
        this.minDecimalSymbolLength = length;
    }

    public void setMaxDecimalSymbolsUntilUnderscore(int amount) {
        this.maxDecimalSymbolsUntilUnderscore = amount;
    }

    public void setMinHexSymbolLength(int length) {
        this.minHexSymbolLength = length;
    }

    public void setMaxHexSymbolsUntilUnderscore(int amount) {
        this.maxHexSymbolsUntilUnderscore = amount;
    }

    public void setMinBinarySymbolLength(int length) {
        this.minBinarySymbolLength = length;
    }

    public void setMaxBinarySymbolsUntilUnderscore(int amount) {
        this.maxBinarySymbolsUntilUnderscore = amount;
    }

    public void setIgnoreFieldNamePattern(String pattern) {
        this.ignoreFieldNamePattern = Pattern.compile(pattern);
    }

    public int[] getDefaultTokens() {
        return new int[]{137, 141, 140, 142};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        if (!this.passesCheck(ast)) {
            this.log(ast.getLineNo(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean isField(DetailAST ast) {
        DetailAST current = ast;
        while (current.getParent() != null && current.getType() != 10) {
            current = current.getParent();
        }
        return current.getType() == 10 && current.branchContains(64) && current.branchContains(39);
    }

    private static String getFieldName(DetailAST ast) {
        DetailAST current = ast;
        while (current.getType() != 10) {
            current = current.getParent();
        }
        current = current.getFirstChild();
        while (current.getType() != 58) {
            current = current.getNextSibling();
        }
        return current.getText();
    }

    private boolean passesCheck(DetailAST ast) {
        boolean passing;
        if (NumericLiteralNeedsUnderscoreCheck.isField(ast) && this.ignoreFieldNamePattern.matcher(NumericLiteralNeedsUnderscoreCheck.getFieldName(ast)).find()) {
            passing = true;
        } else {
            String rawLiteral = ast.getText();
            NumericType type = NumericLiteralNeedsUnderscoreCheck.getNumericType(rawLiteral);
            int minCheckingLength = this.minSymbolsBeforeChecking(type);
            int symbolsUntilUnderscore = this.maxSymbolsUntilUnderscore(type);
            String strippedLiteral = NumericLiteralNeedsUnderscoreCheck.removePrePostfixByType(rawLiteral, type);
            String[] numericSegments = NumericLiteralNeedsUnderscoreCheck.getNumericSegments(strippedLiteral, type);
            passing = true;
            for (String numericSegment : numericSegments) {
                if (NumericLiteralNeedsUnderscoreCheck.numericSegmentPassesRequirement(numericSegment, minCheckingLength, symbolsUntilUnderscore)) continue;
                passing = false;
                break;
            }
        }
        return passing;
    }

    private int minSymbolsBeforeChecking(NumericType type) {
        int minLength;
        if (type.equals((Object)NumericType.DECIMAL)) {
            minLength = this.minDecimalSymbolLength;
        } else if (type.equals((Object)NumericType.HEX)) {
            minLength = this.minHexSymbolLength;
        } else if (type.equals((Object)NumericType.BINARY)) {
            minLength = this.minBinarySymbolLength;
        } else {
            throw new IllegalStateException(UNEXPECTED_NUMERIC_TYPE_ERROR + type.toString());
        }
        return minLength;
    }

    private int maxSymbolsUntilUnderscore(NumericType type) {
        int maxSymbols;
        if (type.equals((Object)NumericType.DECIMAL)) {
            maxSymbols = this.maxDecimalSymbolsUntilUnderscore;
        } else if (type.equals((Object)NumericType.HEX)) {
            maxSymbols = this.maxHexSymbolsUntilUnderscore;
        } else if (type.equals((Object)NumericType.BINARY)) {
            maxSymbols = this.maxBinarySymbolsUntilUnderscore;
        } else {
            throw new IllegalStateException(UNEXPECTED_NUMERIC_TYPE_ERROR + type.toString());
        }
        return maxSymbols;
    }

    private static String[] getNumericSegments(String strippedLiteral, NumericType type) {
        String[] numericSegments;
        if (type.equals((Object)NumericType.DECIMAL)) {
            numericSegments = DECIMAL_SPLITTER.split(strippedLiteral);
        } else if (type.equals((Object)NumericType.HEX)) {
            numericSegments = HEX_SPLITTER.split(strippedLiteral);
        } else if (type.equals((Object)NumericType.BINARY)) {
            numericSegments = new String[]{strippedLiteral};
        } else {
            throw new IllegalStateException(UNEXPECTED_NUMERIC_TYPE_ERROR + type.toString());
        }
        return numericSegments;
    }

    private static NumericType getNumericType(String rawLiteral) {
        String prefix;
        NumericType type = rawLiteral.length() < 2 ? NumericType.DECIMAL : ("0x".equals(prefix = rawLiteral.substring(0, 2)) ? NumericType.HEX : ("0b".equals(prefix) ? NumericType.BINARY : NumericType.DECIMAL));
        return type;
    }

    private static boolean numericSegmentPassesRequirement(String numericSegment, int minLength, int symbolsUntilUnderscore) {
        if (numericSegment.length() < minLength) {
            return true;
        }
        int underscore = 95;
        int symbolCount = 0;
        boolean passes = true;
        for (int i = 0; i < numericSegment.length(); ++i) {
            char current = numericSegment.charAt(i);
            if (symbolCount >= symbolsUntilUnderscore && current != '_') {
                passes = false;
                break;
            }
            if (current == '_') {
                symbolCount = 0;
                continue;
            }
            ++symbolCount;
        }
        return passes;
    }

    private static String removePrePostfixByType(String rawLiteral, NumericType literalType) {
        String processedLiteral;
        if (literalType.equals((Object)NumericType.DECIMAL)) {
            processedLiteral = NumericLiteralNeedsUnderscoreCheck.removeLetterPostfix(rawLiteral);
        } else if (literalType.equals((Object)NumericType.HEX)) {
            processedLiteral = NumericLiteralNeedsUnderscoreCheck.removePrefix(rawLiteral);
            processedLiteral = NumericLiteralNeedsUnderscoreCheck.removePostfixHex(processedLiteral);
        } else if (literalType.equals((Object)NumericType.BINARY)) {
            processedLiteral = NumericLiteralNeedsUnderscoreCheck.removePrefix(rawLiteral);
            processedLiteral = NumericLiteralNeedsUnderscoreCheck.removeLetterPostfix(processedLiteral);
        } else {
            throw new IllegalStateException(UNEXPECTED_NUMERIC_TYPE_ERROR + literalType.toString());
        }
        return processedLiteral;
    }

    private static String removePrefix(String text) {
        return text.substring(2);
    }

    private static String removeLetterPostfix(String text) {
        char lastchar = text.charAt(text.length() - 1);
        String noPostfixText = Character.isDigit(lastchar) ? text : text.substring(0, text.length() - 1);
        return noPostfixText;
    }

    private static String removePostfixHex(String text) {
        char lastchar = Character.toUpperCase(text.charAt(text.length() - 1));
        boolean hasPostfix = false;
        if (lastchar == 'L') {
            hasPostfix = true;
        } else if (lastchar == 'F' && (text.contains("p") || text.contains("P"))) {
            hasPostfix = true;
        }
        String noPostfixText = hasPostfix ? text.substring(0, text.length() - 1) : text;
        return noPostfixText;
    }

    protected static enum NumericType {
        DECIMAL,
        HEX,
        BINARY;

    }
}

