/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class AvoidModifiersForTypesCheck
extends AbstractCheck {
    public static final String MSG_KEY = "avoid.modifiers.for.types";
    private Pattern forbiddenClassesRegexpAnnotation = Pattern.compile("");
    private Pattern forbiddenClassesRegexpFinal = Pattern.compile("");
    private Pattern forbiddenClassesRegexpStatic = Pattern.compile("ULC.+");
    private Pattern forbiddenClassesRegexpTransient = Pattern.compile("");
    private Pattern forbiddenClassesRegexpVolatile = Pattern.compile("");
    private Pattern forbiddenClassesRegexpPrivate = Pattern.compile("");
    private Pattern forbiddenClassesRegexpPackagePrivate = Pattern.compile("");
    private Pattern forbiddenClassesRegexpProtected = Pattern.compile("");
    private Pattern forbiddenClassesRegexpPublic = Pattern.compile("");

    public void setForbiddenClassesRegexpAnnotation(String forbiddenClassesRegexpAnnotation) {
        String regexp = forbiddenClassesRegexpAnnotation == null ? "" : forbiddenClassesRegexpAnnotation;
        this.forbiddenClassesRegexpAnnotation = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpFinal(String forbiddenClassesRegexpFinal) {
        String regexp = forbiddenClassesRegexpFinal == null ? "" : forbiddenClassesRegexpFinal;
        this.forbiddenClassesRegexpFinal = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpStatic(String forbiddenClassesRegexpStatic) {
        String regexp = forbiddenClassesRegexpStatic == null ? "" : forbiddenClassesRegexpStatic;
        this.forbiddenClassesRegexpStatic = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpTransient(String forbiddenClassesRegexpTransient) {
        String regexp = forbiddenClassesRegexpTransient == null ? "" : forbiddenClassesRegexpTransient;
        this.forbiddenClassesRegexpTransient = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpVolatile(String forbiddenClassesRegexpVolatile) {
        String regexp = forbiddenClassesRegexpVolatile == null ? "" : forbiddenClassesRegexpVolatile;
        this.forbiddenClassesRegexpVolatile = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpPrivate(String forbiddenClassesRegexpPrivate) {
        String regexp = forbiddenClassesRegexpPrivate == null ? "" : forbiddenClassesRegexpPrivate;
        this.forbiddenClassesRegexpPrivate = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpPackagePrivate(String forbiddenClassesRegexpPackagePrivate) {
        String regexp = forbiddenClassesRegexpPackagePrivate == null ? "" : forbiddenClassesRegexpPackagePrivate;
        this.forbiddenClassesRegexpPackagePrivate = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpProtected(String forbiddenClassesRegexpProtected) {
        String regexp = forbiddenClassesRegexpProtected == null ? "" : forbiddenClassesRegexpProtected;
        this.forbiddenClassesRegexpProtected = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpPublic(String forbiddenClassesRegexpPublic) {
        String regexp = forbiddenClassesRegexpPublic == null ? "" : forbiddenClassesRegexpPublic;
        this.forbiddenClassesRegexpPublic = Pattern.compile(regexp);
    }

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        String classNameAndPath = AvoidModifiersForTypesCheck.getClassNameAndPath(ast);
        if (classNameAndPath != null) {
            String className = AvoidModifiersForTypesCheck.getClassName(classNameAndPath);
            Set<Integer> modifiersSet = AvoidModifiersForTypesCheck.getModifiers(ast);
            if (ast.getParent().getType() == 6 && !modifiersSet.contains(62) && !modifiersSet.contains(63) && !modifiersSet.contains(61) && this.forbiddenClassesRegexpPackagePrivate.matcher(className).matches()) {
                this.log(ast, MSG_KEY, new Object[]{className, "package-private"});
            }
            for (int modifierType : modifiersSet) {
                if (!this.match(modifierType, className)) continue;
                String tokenName = TokenUtils.getTokenName((int)modifierType);
                tokenName = tokenName.toLowerCase().replaceAll("literal_", "");
                this.log(ast, MSG_KEY, new Object[]{className, tokenName});
            }
        }
    }

    private boolean match(int modifierType, String className) {
        Pattern pattern = this.mapToRegExp(modifierType);
        return pattern.matcher(className).matches();
    }

    private Pattern mapToRegExp(int modifierType) {
        Pattern result = null;
        switch (modifierType) {
            case 159: {
                result = this.forbiddenClassesRegexpAnnotation;
                break;
            }
            case 39: {
                result = this.forbiddenClassesRegexpFinal;
                break;
            }
            case 64: {
                result = this.forbiddenClassesRegexpStatic;
                break;
            }
            case 65: {
                result = this.forbiddenClassesRegexpTransient;
                break;
            }
            case 68: {
                result = this.forbiddenClassesRegexpVolatile;
                break;
            }
            case 61: {
                result = this.forbiddenClassesRegexpPrivate;
                break;
            }
            case 63: {
                result = this.forbiddenClassesRegexpProtected;
                break;
            }
            case 62: {
                result = this.forbiddenClassesRegexpPublic;
                break;
            }
            default: {
                Utils.reportInvalidToken(modifierType);
            }
        }
        return result;
    }

    private static String getClassNameAndPath(DetailAST variableDefNode) {
        String result = null;
        DetailAST type = variableDefNode.findFirstToken(13);
        DetailAST textWithoutDots = type.findFirstToken(58);
        if (textWithoutDots == null) {
            DetailAST parentDotAST = type.findFirstToken(59);
            if (parentDotAST != null) {
                FullIdent dottedPathIdent = FullIdent.createFullIdentBelow((DetailAST)parentDotAST);
                DetailAST nameAST = parentDotAST.getLastChild();
                result = dottedPathIdent.getText() + "." + nameAST.getText();
            }
        } else {
            result = textWithoutDots.getText();
        }
        return result;
    }

    private static String getClassName(String classNameAndPath) {
        return classNameAndPath.replaceAll(".+\\.", "");
    }

    private static Set<Integer> getModifiers(DetailAST variableDefAst) {
        HashSet<Integer> modifiersSet = new HashSet<Integer>();
        DetailAST modifiersAST = variableDefAst.findFirstToken(5);
        for (DetailAST modifier : AvoidModifiersForTypesCheck.getChildren(modifiersAST)) {
            modifiersSet.add(modifier.getType());
        }
        return modifiersSet;
    }

    private static List<DetailAST> getChildren(DetailAST node) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode = node.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            result.add(curNode);
        }
        return result;
    }
}

