/*
 * Decompiled with CFR 0.152.
 */
package com.github.qcloudsms;

import com.github.qcloudsms.SmsResultBase;
import com.github.qcloudsms.httpclient.HTTPResponse;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SmsMultiSenderResult
extends SmsResultBase {
    public int result;
    public String errMsg = "";
    public String ext = "";
    public ArrayList<Detail> details = new ArrayList();

    public SmsMultiSenderResult parseFromHTTPResponse(HTTPResponse response) throws JSONException {
        JSONObject json = this.parseToJson(response);
        this.result = json.getInt("result");
        this.errMsg = json.getString("errmsg");
        if (json.has("ext")) {
            this.ext = json.getString("ext");
        }
        if (json.has("detail") && !json.isNull("detail")) {
            JSONArray jsonDetail = json.getJSONArray("detail");
            for (int i = 0; i < jsonDetail.length(); ++i) {
                this.details.add(new Detail().parse(jsonDetail.getJSONObject(i)));
            }
        }
        return this;
    }

    public class Detail {
        public int result;
        public String errmsg = "";
        public String mobile = "";
        public String nationcode = "";
        public String sid = "";
        public int fee = 0;

        public String toString() {
            String[] fields = new String[]{"result", "errmsg", "mobile", "nationcode", "sid", "fee"};
            return new JSONObject((Object)this, fields).toString();
        }

        public Detail parse(JSONObject json) throws JSONException {
            this.result = json.getInt("result");
            this.errmsg = json.getString("errmsg");
            if (json.has("mobile")) {
                this.mobile = json.getString("mobile");
            }
            if (json.has("nationcode")) {
                this.nationcode = json.getString("nationcode");
            }
            if (json.has("sid")) {
                this.sid = json.getString("sid");
            }
            if (json.has("fee")) {
                this.fee = json.getInt("fee");
            }
            return this;
        }
    }
}

